package zio.aws.applicationcostprofiler.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.applicationcostprofiler.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListReportDefinitionsResponse(
    reportDefinitions: Option[
      Iterable[zio.aws.applicationcostprofiler.model.ReportDefinition]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsResponse = {
    import ListReportDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsResponse
      .builder()
      .optionallyWith(
        reportDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reportDefinitions)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse.ReadOnly =
    zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse
      .wrap(buildAwsValue())
}
object ListReportDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse =
      zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse(
        reportDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def reportDefinitions: Option[
      List[zio.aws.applicationcostprofiler.model.ReportDefinition.ReadOnly]
    ]
    def nextToken: Option[Token]
    def getReportDefinitions: ZIO[Any, AwsError, List[
      zio.aws.applicationcostprofiler.model.ReportDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("reportDefinitions", reportDefinitions)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsResponse
  ) extends zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse.ReadOnly {
    override val reportDefinitions: Option[
      List[zio.aws.applicationcostprofiler.model.ReportDefinition.ReadOnly]
    ] = scala
      .Option(impl.reportDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationcostprofiler.model.ReportDefinition.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.applicationcostprofiler.model.primitives.Token(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsResponse
  ): zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
