package zio.aws.applicationcostprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.applicationcostprofiler.model.primitives.{
  Timestamp,
  ReportDescription,
  ReportId
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetReportDefinitionResponse(
    reportId: ReportId,
    reportDescription: ReportDescription,
    reportFrequency: zio.aws.applicationcostprofiler.model.ReportFrequency,
    format: zio.aws.applicationcostprofiler.model.Format,
    destinationS3Location: zio.aws.applicationcostprofiler.model.S3Location,
    createdAt: Timestamp,
    lastUpdated: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationcostprofiler.model.GetReportDefinitionResponse = {
    import GetReportDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationcostprofiler.model.GetReportDefinitionResponse
      .builder()
      .reportId(ReportId.unwrap(reportId): java.lang.String)
      .reportDescription(
        ReportDescription.unwrap(reportDescription): java.lang.String
      )
      .reportFrequency(reportFrequency.unwrap)
      .format(format.unwrap)
      .destinationS3Location(destinationS3Location.buildAwsValue())
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .lastUpdated(Timestamp.unwrap(lastUpdated): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse.ReadOnly =
    zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse
      .wrap(buildAwsValue())
}
object GetReportDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationcostprofiler.model.GetReportDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse =
      zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse(
        reportId,
        reportDescription,
        reportFrequency,
        format,
        destinationS3Location.asEditable,
        createdAt,
        lastUpdated
      )
    def reportId: ReportId
    def reportDescription: ReportDescription
    def reportFrequency: zio.aws.applicationcostprofiler.model.ReportFrequency
    def format: zio.aws.applicationcostprofiler.model.Format
    def destinationS3Location
        : zio.aws.applicationcostprofiler.model.S3Location.ReadOnly
    def createdAt: Timestamp
    def lastUpdated: Timestamp
    def getReportId: ZIO[Any, Nothing, ReportId] = ZIO.succeed(reportId)
    def getReportDescription: ZIO[Any, Nothing, ReportDescription] =
      ZIO.succeed(reportDescription)
    def getReportFrequency: ZIO[
      Any,
      Nothing,
      zio.aws.applicationcostprofiler.model.ReportFrequency
    ] = ZIO.succeed(reportFrequency)
    def getFormat
        : ZIO[Any, Nothing, zio.aws.applicationcostprofiler.model.Format] =
      ZIO.succeed(format)
    def getDestinationS3Location: ZIO[
      Any,
      Nothing,
      zio.aws.applicationcostprofiler.model.S3Location.ReadOnly
    ] = ZIO.succeed(destinationS3Location)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getLastUpdated: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(lastUpdated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.GetReportDefinitionResponse
  ) extends zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse.ReadOnly {
    override val reportId: ReportId =
      zio.aws.applicationcostprofiler.model.primitives.ReportId(impl.reportId())
    override val reportDescription: ReportDescription =
      zio.aws.applicationcostprofiler.model.primitives
        .ReportDescription(impl.reportDescription())
    override val reportFrequency
        : zio.aws.applicationcostprofiler.model.ReportFrequency =
      zio.aws.applicationcostprofiler.model.ReportFrequency
        .wrap(impl.reportFrequency())
    override val format: zio.aws.applicationcostprofiler.model.Format =
      zio.aws.applicationcostprofiler.model.Format.wrap(impl.format())
    override val destinationS3Location
        : zio.aws.applicationcostprofiler.model.S3Location.ReadOnly =
      zio.aws.applicationcostprofiler.model.S3Location
        .wrap(impl.destinationS3Location())
    override val createdAt: Timestamp =
      zio.aws.applicationcostprofiler.model.primitives
        .Timestamp(impl.createdAt())
    override val lastUpdated: Timestamp =
      zio.aws.applicationcostprofiler.model.primitives
        .Timestamp(impl.lastUpdated())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.GetReportDefinitionResponse
  ): zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
