package zio.aws.applicationcostprofiler
import zio.aws.applicationcostprofiler.model.PutReportDefinitionResponse.ReadOnly
import zio.aws.applicationcostprofiler.model.{
  ListReportDefinitionsRequest,
  GetReportDefinitionRequest,
  UpdateReportDefinitionRequest,
  DeleteReportDefinitionRequest,
  PutReportDefinitionRequest,
  ImportApplicationUsageRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.applicationcostprofiler.ApplicationCostProfilerAsyncClient
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object ApplicationCostProfilerMock extends Mock[ApplicationCostProfiler] {
  object ListReportDefinitions
      extends Stream[
        ListReportDefinitionsRequest,
        AwsError,
        zio.aws.applicationcostprofiler.model.ReportDefinition.ReadOnly
      ]
  object ListReportDefinitionsPaginated
      extends Effect[
        ListReportDefinitionsRequest,
        AwsError,
        zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse.ReadOnly
      ]
  object DeleteReportDefinition
      extends Effect[
        DeleteReportDefinitionRequest,
        AwsError,
        zio.aws.applicationcostprofiler.model.DeleteReportDefinitionResponse.ReadOnly
      ]
  object PutReportDefinition
      extends Effect[PutReportDefinitionRequest, AwsError, ReadOnly]
  object ImportApplicationUsage
      extends Effect[
        ImportApplicationUsageRequest,
        AwsError,
        zio.aws.applicationcostprofiler.model.ImportApplicationUsageResponse.ReadOnly
      ]
  object GetReportDefinition
      extends Effect[
        GetReportDefinitionRequest,
        AwsError,
        zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse.ReadOnly
      ]
  object UpdateReportDefinition
      extends Effect[
        UpdateReportDefinitionRequest,
        AwsError,
        zio.aws.applicationcostprofiler.model.UpdateReportDefinitionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ApplicationCostProfiler] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new ApplicationCostProfiler {
          val api: ApplicationCostProfilerAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : ApplicationCostProfiler = this
          def listReportDefinitions(
              request: ListReportDefinitionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.applicationcostprofiler.model.ReportDefinition.ReadOnly
          ] = rts.unsafeRun(proxy(ListReportDefinitions, request))
          def listReportDefinitionsPaginated(
              request: ListReportDefinitionsRequest
          ): IO[
            AwsError,
            zio.aws.applicationcostprofiler.model.ListReportDefinitionsResponse.ReadOnly
          ] = proxy(ListReportDefinitionsPaginated, request)
          def deleteReportDefinition(
              request: DeleteReportDefinitionRequest
          ): IO[
            AwsError,
            zio.aws.applicationcostprofiler.model.DeleteReportDefinitionResponse.ReadOnly
          ] = proxy(DeleteReportDefinition, request)
          def putReportDefinition(
              request: PutReportDefinitionRequest
          ): IO[AwsError, ReadOnly] = proxy(PutReportDefinition, request)
          def importApplicationUsage(
              request: ImportApplicationUsageRequest
          ): IO[
            AwsError,
            zio.aws.applicationcostprofiler.model.ImportApplicationUsageResponse.ReadOnly
          ] = proxy(ImportApplicationUsage, request)
          def getReportDefinition(request: GetReportDefinitionRequest): IO[
            AwsError,
            zio.aws.applicationcostprofiler.model.GetReportDefinitionResponse.ReadOnly
          ] = proxy(GetReportDefinition, request)
          def updateReportDefinition(
              request: UpdateReportDefinitionRequest
          ): IO[
            AwsError,
            zio.aws.applicationcostprofiler.model.UpdateReportDefinitionResponse.ReadOnly
          ] = proxy(UpdateReportDefinition, request)
        }
      }
    }
    .toLayer
}
