package zio.aws.applicationcostprofiler.model
import scala.jdk.CollectionConverters._
sealed trait S3BucketRegion {
  def unwrap: software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion
}
object S3BucketRegion {
  def wrap(
      value: software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion
  ): zio.aws.applicationcostprofiler.model.S3BucketRegion = value match {
    case software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion.AP_EAST_1 =>
      val r = `ap-east-1`
      r
    case software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion.ME_SOUTH_1 =>
      val r = `me-south-1`
      r
    case software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion.EU_SOUTH_1 =>
      val r = `eu-south-1`
      r
    case software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion.AF_SOUTH_1 =>
      val r = `af-south-1`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationcostprofiler.model.S3BucketRegion {
    override def unwrap
        : software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion =
      software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion.UNKNOWN_TO_SDK_VERSION
  }
  case object `ap-east-1`
      extends zio.aws.applicationcostprofiler.model.S3BucketRegion {
    override def unwrap
        : software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion =
      software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion.AP_EAST_1
  }
  case object `me-south-1`
      extends zio.aws.applicationcostprofiler.model.S3BucketRegion {
    override def unwrap
        : software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion =
      software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion.ME_SOUTH_1
  }
  case object `eu-south-1`
      extends zio.aws.applicationcostprofiler.model.S3BucketRegion {
    override def unwrap
        : software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion =
      software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion.EU_SOUTH_1
  }
  case object `af-south-1`
      extends zio.aws.applicationcostprofiler.model.S3BucketRegion {
    override def unwrap
        : software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion =
      software.amazon.awssdk.services.applicationcostprofiler.model.S3BucketRegion.AF_SOUTH_1
  }
}
