package zio.aws.applicationcostprofiler.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.applicationcostprofiler.model.primitives.ImportId
import scala.jdk.CollectionConverters._
final case class ImportApplicationUsageResponse(importId: ImportId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationcostprofiler.model.ImportApplicationUsageResponse = {
    import ImportApplicationUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationcostprofiler.model.ImportApplicationUsageResponse
      .builder()
      .importId(ImportId.unwrap(importId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationcostprofiler.model.ImportApplicationUsageResponse.ReadOnly =
    zio.aws.applicationcostprofiler.model.ImportApplicationUsageResponse
      .wrap(buildAwsValue())
}
object ImportApplicationUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationcostprofiler.model.ImportApplicationUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationcostprofiler.model.ImportApplicationUsageResponse =
      zio.aws.applicationcostprofiler.model
        .ImportApplicationUsageResponse(importId)
    def importId: ImportId
    def getImportId: ZIO[Any, Nothing, ImportId] = ZIO.succeed(importId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.ImportApplicationUsageResponse
  ) extends zio.aws.applicationcostprofiler.model.ImportApplicationUsageResponse.ReadOnly {
    override val importId: ImportId =
      zio.aws.applicationcostprofiler.model.primitives.ImportId(impl.importId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationcostprofiler.model.ImportApplicationUsageResponse
  ): zio.aws.applicationcostprofiler.model.ImportApplicationUsageResponse.ReadOnly =
    new Wrapper(impl)
}
