package zio.aws.applicationautoscaling.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.applicationautoscaling.model.primitives.{
  DisableScaleIn,
  Cooldown,
  MetricScale
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TargetTrackingScalingPolicyConfiguration(
    targetValue: MetricScale,
    predefinedMetricSpecification: Optional[
      zio.aws.applicationautoscaling.model.PredefinedMetricSpecification
    ] = Optional.Absent,
    customizedMetricSpecification: Optional[
      zio.aws.applicationautoscaling.model.CustomizedMetricSpecification
    ] = Optional.Absent,
    scaleOutCooldown: Optional[Cooldown] = Optional.Absent,
    scaleInCooldown: Optional[Cooldown] = Optional.Absent,
    disableScaleIn: Optional[DisableScaleIn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration = {
    import TargetTrackingScalingPolicyConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
      .builder()
      .targetValue(MetricScale.unwrap(targetValue): java.lang.Double)
      .optionallyWith(
        predefinedMetricSpecification.map(value => value.buildAwsValue())
      )(_.predefinedMetricSpecification)
      .optionallyWith(
        customizedMetricSpecification.map(value => value.buildAwsValue())
      )(_.customizedMetricSpecification)
      .optionallyWith(
        scaleOutCooldown.map(value => Cooldown.unwrap(value): Integer)
      )(_.scaleOutCooldown)
      .optionallyWith(
        scaleInCooldown.map(value => Cooldown.unwrap(value): Integer)
      )(_.scaleInCooldown)
      .optionallyWith(
        disableScaleIn.map(value =>
          DisableScaleIn.unwrap(value): java.lang.Boolean
        )
      )(_.disableScaleIn)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration.ReadOnly =
    zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
      .wrap(buildAwsValue())
}
object TargetTrackingScalingPolicyConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration =
      zio.aws.applicationautoscaling.model
        .TargetTrackingScalingPolicyConfiguration(
          targetValue,
          predefinedMetricSpecification.map(value => value.asEditable),
          customizedMetricSpecification.map(value => value.asEditable),
          scaleOutCooldown.map(value => value),
          scaleInCooldown.map(value => value),
          disableScaleIn.map(value => value)
        )
    def targetValue: MetricScale
    def predefinedMetricSpecification: Optional[
      zio.aws.applicationautoscaling.model.PredefinedMetricSpecification.ReadOnly
    ]
    def customizedMetricSpecification: Optional[
      zio.aws.applicationautoscaling.model.CustomizedMetricSpecification.ReadOnly
    ]
    def scaleOutCooldown: Optional[Cooldown]
    def scaleInCooldown: Optional[Cooldown]
    def disableScaleIn: Optional[DisableScaleIn]
    def getTargetValue: ZIO[Any, Nothing, MetricScale] =
      ZIO.succeed(targetValue)
    def getPredefinedMetricSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.PredefinedMetricSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "predefinedMetricSpecification",
      predefinedMetricSpecification
    )
    def getCustomizedMetricSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.CustomizedMetricSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customizedMetricSpecification",
      customizedMetricSpecification
    )
    def getScaleOutCooldown: ZIO[Any, AwsError, Cooldown] =
      AwsError.unwrapOptionField("scaleOutCooldown", scaleOutCooldown)
    def getScaleInCooldown: ZIO[Any, AwsError, Cooldown] =
      AwsError.unwrapOptionField("scaleInCooldown", scaleInCooldown)
    def getDisableScaleIn: ZIO[Any, AwsError, DisableScaleIn] =
      AwsError.unwrapOptionField("disableScaleIn", disableScaleIn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
  ) extends zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration.ReadOnly {
    override val targetValue: MetricScale =
      zio.aws.applicationautoscaling.model.primitives
        .MetricScale(impl.targetValue())
    override val predefinedMetricSpecification: Optional[
      zio.aws.applicationautoscaling.model.PredefinedMetricSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.predefinedMetricSpecification())
      .map(value =>
        zio.aws.applicationautoscaling.model.PredefinedMetricSpecification
          .wrap(value)
      )
    override val customizedMetricSpecification: Optional[
      zio.aws.applicationautoscaling.model.CustomizedMetricSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customizedMetricSpecification())
      .map(value =>
        zio.aws.applicationautoscaling.model.CustomizedMetricSpecification
          .wrap(value)
      )
    override val scaleOutCooldown: Optional[Cooldown] = zio.aws.core.internal
      .optionalFromNullable(impl.scaleOutCooldown())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.Cooldown(value)
      )
    override val scaleInCooldown: Optional[Cooldown] = zio.aws.core.internal
      .optionalFromNullable(impl.scaleInCooldown())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.Cooldown(value)
      )
    override val disableScaleIn: Optional[DisableScaleIn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableScaleIn())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives.DisableScaleIn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
  ): zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration.ReadOnly =
    new Wrapper(impl)
}
