package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.{
  TargetTrackingMetricUnit,
  XmlString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TargetTrackingMetricStat(
    metric: zio.aws.applicationautoscaling.model.TargetTrackingMetric,
    stat: XmlString,
    unit: Optional[TargetTrackingMetricUnit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricStat = {
    import TargetTrackingMetricStat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricStat
      .builder()
      .metric(metric.buildAwsValue())
      .stat(XmlString.unwrap(stat): java.lang.String)
      .optionallyWith(
        unit.map(value =>
          TargetTrackingMetricUnit.unwrap(value): java.lang.String
        )
      )(_.unit)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.TargetTrackingMetricStat.ReadOnly =
    zio.aws.applicationautoscaling.model.TargetTrackingMetricStat
      .wrap(buildAwsValue())
}
object TargetTrackingMetricStat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricStat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.TargetTrackingMetricStat =
      zio.aws.applicationautoscaling.model.TargetTrackingMetricStat(
        metric.asEditable,
        stat,
        unit.map(value => value)
      )
    def metric
        : zio.aws.applicationautoscaling.model.TargetTrackingMetric.ReadOnly
    def stat: XmlString
    def unit: Optional[TargetTrackingMetricUnit]
    def getMetric: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.TargetTrackingMetric.ReadOnly
    ] = ZIO.succeed(metric)
    def getStat: ZIO[Any, Nothing, XmlString] = ZIO.succeed(stat)
    def getUnit: ZIO[Any, AwsError, TargetTrackingMetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricStat
  ) extends zio.aws.applicationautoscaling.model.TargetTrackingMetricStat.ReadOnly {
    override val metric
        : zio.aws.applicationautoscaling.model.TargetTrackingMetric.ReadOnly =
      zio.aws.applicationautoscaling.model.TargetTrackingMetric
        .wrap(impl.metric())
    override val stat: XmlString =
      zio.aws.applicationautoscaling.model.primitives.XmlString(impl.stat())
    override val unit: Optional[TargetTrackingMetricUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives
            .TargetTrackingMetricUnit(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricStat
  ): zio.aws.applicationautoscaling.model.TargetTrackingMetricStat.ReadOnly =
    new Wrapper(impl)
}
