package zio.aws.applicationautoscaling.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.applicationautoscaling.model.primitives.{
  ResourceCapacity,
  XmlString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class NotScaledReason(
    code: XmlString,
    maxCapacity: Optional[ResourceCapacity] = Optional.Absent,
    minCapacity: Optional[ResourceCapacity] = Optional.Absent,
    currentCapacity: Optional[ResourceCapacity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.NotScaledReason = {
    import NotScaledReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.NotScaledReason
      .builder()
      .code(XmlString.unwrap(code): java.lang.String)
      .optionallyWith(
        maxCapacity.map(value => ResourceCapacity.unwrap(value): Integer)
      )(_.maxCapacity)
      .optionallyWith(
        minCapacity.map(value => ResourceCapacity.unwrap(value): Integer)
      )(_.minCapacity)
      .optionallyWith(
        currentCapacity.map(value => ResourceCapacity.unwrap(value): Integer)
      )(_.currentCapacity)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.NotScaledReason.ReadOnly =
    zio.aws.applicationautoscaling.model.NotScaledReason.wrap(buildAwsValue())
}
object NotScaledReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.NotScaledReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationautoscaling.model.NotScaledReason =
      zio.aws.applicationautoscaling.model.NotScaledReason(
        code,
        maxCapacity.map(value => value),
        minCapacity.map(value => value),
        currentCapacity.map(value => value)
      )
    def code: XmlString
    def maxCapacity: Optional[ResourceCapacity]
    def minCapacity: Optional[ResourceCapacity]
    def currentCapacity: Optional[ResourceCapacity]
    def getCode: ZIO[Any, Nothing, XmlString] = ZIO.succeed(code)
    def getMaxCapacity: ZIO[Any, AwsError, ResourceCapacity] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
    def getMinCapacity: ZIO[Any, AwsError, ResourceCapacity] =
      AwsError.unwrapOptionField("minCapacity", minCapacity)
    def getCurrentCapacity: ZIO[Any, AwsError, ResourceCapacity] =
      AwsError.unwrapOptionField("currentCapacity", currentCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.NotScaledReason
  ) extends zio.aws.applicationautoscaling.model.NotScaledReason.ReadOnly {
    override val code: XmlString =
      zio.aws.applicationautoscaling.model.primitives.XmlString(impl.code())
    override val maxCapacity: Optional[ResourceCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.maxCapacity())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.ResourceCapacity(value)
      )
    override val minCapacity: Optional[ResourceCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.minCapacity())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.ResourceCapacity(value)
      )
    override val currentCapacity: Optional[ResourceCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentCapacity())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives
            .ResourceCapacity(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.NotScaledReason
  ): zio.aws.applicationautoscaling.model.NotScaledReason.ReadOnly =
    new Wrapper(impl)
}
