package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.{
  TargetTrackingMetricNamespace,
  TargetTrackingMetricName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TargetTrackingMetric(
    dimensions: Optional[Iterable[
      zio.aws.applicationautoscaling.model.TargetTrackingMetricDimension
    ]] = Optional.Absent,
    metricName: Optional[TargetTrackingMetricName] = Optional.Absent,
    namespace: Optional[TargetTrackingMetricNamespace] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetric = {
    import TargetTrackingMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetric
      .builder()
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(
        metricName.map(value =>
          TargetTrackingMetricName.unwrap(value): java.lang.String
        )
      )(_.metricName)
      .optionallyWith(
        namespace.map(value =>
          TargetTrackingMetricNamespace.unwrap(value): java.lang.String
        )
      )(_.namespace)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.TargetTrackingMetric.ReadOnly =
    zio.aws.applicationautoscaling.model.TargetTrackingMetric
      .wrap(buildAwsValue())
}
object TargetTrackingMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationautoscaling.model.TargetTrackingMetric =
      zio.aws.applicationautoscaling.model.TargetTrackingMetric(
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metricName.map(value => value),
        namespace.map(value => value)
      )
    def dimensions: Optional[List[
      zio.aws.applicationautoscaling.model.TargetTrackingMetricDimension.ReadOnly
    ]]
    def metricName: Optional[TargetTrackingMetricName]
    def namespace: Optional[TargetTrackingMetricNamespace]
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.applicationautoscaling.model.TargetTrackingMetricDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getMetricName: ZIO[Any, AwsError, TargetTrackingMetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getNamespace: ZIO[Any, AwsError, TargetTrackingMetricNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetric
  ) extends zio.aws.applicationautoscaling.model.TargetTrackingMetric.ReadOnly {
    override val dimensions: Optional[List[
      zio.aws.applicationautoscaling.model.TargetTrackingMetricDimension.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationautoscaling.model.TargetTrackingMetricDimension
            .wrap(item)
        }.toList
      )
    override val metricName: Optional[TargetTrackingMetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricName())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives
            .TargetTrackingMetricName(value)
        )
    override val namespace: Optional[TargetTrackingMetricNamespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namespace())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives
            .TargetTrackingMetricNamespace(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetric
  ): zio.aws.applicationautoscaling.model.TargetTrackingMetric.ReadOnly =
    new Wrapper(impl)
}
