package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.{
  TagKey,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceARN: AmazonResourceName,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.UntagResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.UntagResourceRequest.ReadOnly =
    zio.aws.applicationautoscaling.model.UntagResourceRequest
      .wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationautoscaling.model.UntagResourceRequest =
      zio.aws.applicationautoscaling.model
        .UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: AmazonResourceName
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.UntagResourceRequest
  ) extends zio.aws.applicationautoscaling.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.applicationautoscaling.model.primitives
        .AmazonResourceName(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.applicationautoscaling.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.UntagResourceRequest
  ): zio.aws.applicationautoscaling.model.UntagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
