package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.{
  ReturnData,
  XmlString,
  Id,
  Expression
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TargetTrackingMetricDataQuery(
    expression: Optional[Expression] = Optional.Absent,
    id: Id,
    label: Optional[XmlString] = Optional.Absent,
    metricStat: Optional[
      zio.aws.applicationautoscaling.model.TargetTrackingMetricStat
    ] = Optional.Absent,
    returnData: Optional[ReturnData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricDataQuery = {
    import TargetTrackingMetricDataQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricDataQuery
      .builder()
      .optionallyWith(
        expression.map(value => Expression.unwrap(value): java.lang.String)
      )(_.expression)
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(
        label.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.label)
      .optionallyWith(metricStat.map(value => value.buildAwsValue()))(
        _.metricStat
      )
      .optionallyWith(
        returnData.map(value => ReturnData.unwrap(value): java.lang.Boolean)
      )(_.returnData)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.TargetTrackingMetricDataQuery.ReadOnly =
    zio.aws.applicationautoscaling.model.TargetTrackingMetricDataQuery
      .wrap(buildAwsValue())
}
object TargetTrackingMetricDataQuery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricDataQuery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.TargetTrackingMetricDataQuery =
      zio.aws.applicationautoscaling.model.TargetTrackingMetricDataQuery(
        expression.map(value => value),
        id,
        label.map(value => value),
        metricStat.map(value => value.asEditable),
        returnData.map(value => value)
      )
    def expression: Optional[Expression]
    def id: Id
    def label: Optional[XmlString]
    def metricStat: Optional[
      zio.aws.applicationautoscaling.model.TargetTrackingMetricStat.ReadOnly
    ]
    def returnData: Optional[ReturnData]
    def getExpression: ZIO[Any, AwsError, Expression] =
      AwsError.unwrapOptionField("expression", expression)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getLabel: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("label", label)
    def getMetricStat: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.TargetTrackingMetricStat.ReadOnly
    ] = AwsError.unwrapOptionField("metricStat", metricStat)
    def getReturnData: ZIO[Any, AwsError, ReturnData] =
      AwsError.unwrapOptionField("returnData", returnData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricDataQuery
  ) extends zio.aws.applicationautoscaling.model.TargetTrackingMetricDataQuery.ReadOnly {
    override val expression: Optional[Expression] = zio.aws.core.internal
      .optionalFromNullable(impl.expression())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.Expression(value)
      )
    override val id: Id =
      zio.aws.applicationautoscaling.model.primitives.Id(impl.id())
    override val label: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.XmlString(value)
      )
    override val metricStat: Optional[
      zio.aws.applicationautoscaling.model.TargetTrackingMetricStat.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metricStat())
      .map(value =>
        zio.aws.applicationautoscaling.model.TargetTrackingMetricStat
          .wrap(value)
      )
    override val returnData: Optional[ReturnData] = zio.aws.core.internal
      .optionalFromNullable(impl.returnData())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.ReturnData(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricDataQuery
  ): zio.aws.applicationautoscaling.model.TargetTrackingMetricDataQuery.ReadOnly =
    new Wrapper(impl)
}
