package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.{
  MetricUnit,
  MetricNamespace,
  MetricName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomizedMetricSpecification(
    metricName: Optional[MetricName] = Optional.Absent,
    namespace: Optional[MetricNamespace] = Optional.Absent,
    dimensions: Optional[
      Iterable[zio.aws.applicationautoscaling.model.MetricDimension]
    ] = Optional.Absent,
    statistic: Optional[zio.aws.applicationautoscaling.model.MetricStatistic] =
      Optional.Absent,
    unit: Optional[MetricUnit] = Optional.Absent,
    metrics: Optional[Iterable[
      zio.aws.applicationautoscaling.model.TargetTrackingMetricDataQuery
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.CustomizedMetricSpecification = {
    import CustomizedMetricSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.CustomizedMetricSpecification
      .builder()
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        namespace.map(value => MetricNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(
        unit.map(value => MetricUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metrics)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.CustomizedMetricSpecification.ReadOnly =
    zio.aws.applicationautoscaling.model.CustomizedMetricSpecification
      .wrap(buildAwsValue())
}
object CustomizedMetricSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.CustomizedMetricSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.CustomizedMetricSpecification =
      zio.aws.applicationautoscaling.model.CustomizedMetricSpecification(
        metricName.map(value => value),
        namespace.map(value => value),
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statistic.map(value => value),
        unit.map(value => value),
        metrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricName: Optional[MetricName]
    def namespace: Optional[MetricNamespace]
    def dimensions: Optional[
      List[zio.aws.applicationautoscaling.model.MetricDimension.ReadOnly]
    ]
    def statistic
        : Optional[zio.aws.applicationautoscaling.model.MetricStatistic]
    def unit: Optional[MetricUnit]
    def metrics: Optional[List[
      zio.aws.applicationautoscaling.model.TargetTrackingMetricDataQuery.ReadOnly
    ]]
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getNamespace: ZIO[Any, AwsError, MetricNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.applicationautoscaling.model.MetricDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getStatistic: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.MetricStatistic
    ] = AwsError.unwrapOptionField("statistic", statistic)
    def getUnit: ZIO[Any, AwsError, MetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getMetrics: ZIO[Any, AwsError, List[
      zio.aws.applicationautoscaling.model.TargetTrackingMetricDataQuery.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.CustomizedMetricSpecification
  ) extends zio.aws.applicationautoscaling.model.CustomizedMetricSpecification.ReadOnly {
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.MetricName(value)
      )
    override val namespace: Optional[MetricNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.MetricNamespace(value)
      )
    override val dimensions: Optional[
      List[zio.aws.applicationautoscaling.model.MetricDimension.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationautoscaling.model.MetricDimension.wrap(item)
        }.toList
      )
    override val statistic
        : Optional[zio.aws.applicationautoscaling.model.MetricStatistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value =>
          zio.aws.applicationautoscaling.model.MetricStatistic.wrap(value)
        )
    override val unit: Optional[MetricUnit] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.MetricUnit(value)
      )
    override val metrics: Optional[List[
      zio.aws.applicationautoscaling.model.TargetTrackingMetricDataQuery.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.metrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationautoscaling.model.TargetTrackingMetricDataQuery
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.CustomizedMetricSpecification
  ): zio.aws.applicationautoscaling.model.CustomizedMetricSpecification.ReadOnly =
    new Wrapper(impl)
}
