package zio.aws.applicationautoscaling.model
import scala.jdk.CollectionConverters.*
sealed trait ScalableDimension {
  def unwrap: software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension
}
object ScalableDimension {
  def wrap(
      value: software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension
  ): zio.aws.applicationautoscaling.model.ScalableDimension = value match {
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.ECS_SERVICE_DESIRED_COUNT =>
      val r = `ecs:service:DesiredCount`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.EC2_SPOT_FLEET_REQUEST_TARGET_CAPACITY =>
      val r = `ec2:spot-fleet-request:TargetCapacity`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.ELASTICMAPREDUCE_INSTANCEGROUP_INSTANCE_COUNT =>
      val r = `elasticmapreduce:instancegroup:InstanceCount`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.APPSTREAM_FLEET_DESIRED_CAPACITY =>
      val r = `appstream:fleet:DesiredCapacity`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.DYNAMODB_TABLE_READ_CAPACITY_UNITS =>
      val r = `dynamodb:table:ReadCapacityUnits`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.DYNAMODB_TABLE_WRITE_CAPACITY_UNITS =>
      val r = `dynamodb:table:WriteCapacityUnits`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.DYNAMODB_INDEX_READ_CAPACITY_UNITS =>
      val r = `dynamodb:index:ReadCapacityUnits`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.DYNAMODB_INDEX_WRITE_CAPACITY_UNITS =>
      val r = `dynamodb:index:WriteCapacityUnits`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.RDS_CLUSTER_READ_REPLICA_COUNT =>
      val r = `rds:cluster:ReadReplicaCount`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.SAGEMAKER_VARIANT_DESIRED_INSTANCE_COUNT =>
      val r = `sagemaker:variant:DesiredInstanceCount`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.CUSTOM_RESOURCE_RESOURCE_TYPE_PROPERTY =>
      val r = `custom-resource:ResourceType:Property`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.COMPREHEND_DOCUMENT_CLASSIFIER_ENDPOINT_DESIRED_INFERENCE_UNITS =>
      val r = `comprehend:document-classifier-endpoint:DesiredInferenceUnits`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.COMPREHEND_ENTITY_RECOGNIZER_ENDPOINT_DESIRED_INFERENCE_UNITS =>
      val r = `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.LAMBDA_FUNCTION_PROVISIONED_CONCURRENCY =>
      val r = `lambda:function:ProvisionedConcurrency`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.CASSANDRA_TABLE_READ_CAPACITY_UNITS =>
      val r = `cassandra:table:ReadCapacityUnits`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.CASSANDRA_TABLE_WRITE_CAPACITY_UNITS =>
      val r = `cassandra:table:WriteCapacityUnits`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.KAFKA_BROKER_STORAGE_VOLUME_SIZE =>
      val r = `kafka:broker-storage:VolumeSize`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.ELASTICACHE_REPLICATION_GROUP_NODE_GROUPS =>
      val r = `elasticache:replication-group:NodeGroups`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.ELASTICACHE_REPLICATION_GROUP_REPLICAS =>
      val r = `elasticache:replication-group:Replicas`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.NEPTUNE_CLUSTER_READ_REPLICA_COUNT =>
      val r = `neptune:cluster:ReadReplicaCount`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.SAGEMAKER_VARIANT_DESIRED_PROVISIONED_CONCURRENCY =>
      val r = `sagemaker:variant:DesiredProvisionedConcurrency`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.UNKNOWN_TO_SDK_VERSION
  }
  case object `ecs:service:DesiredCount`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.ECS_SERVICE_DESIRED_COUNT
  }
  case object `ec2:spot-fleet-request:TargetCapacity`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.EC2_SPOT_FLEET_REQUEST_TARGET_CAPACITY
  }
  case object `elasticmapreduce:instancegroup:InstanceCount`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.ELASTICMAPREDUCE_INSTANCEGROUP_INSTANCE_COUNT
  }
  case object `appstream:fleet:DesiredCapacity`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.APPSTREAM_FLEET_DESIRED_CAPACITY
  }
  case object `dynamodb:table:ReadCapacityUnits`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.DYNAMODB_TABLE_READ_CAPACITY_UNITS
  }
  case object `dynamodb:table:WriteCapacityUnits`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.DYNAMODB_TABLE_WRITE_CAPACITY_UNITS
  }
  case object `dynamodb:index:ReadCapacityUnits`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.DYNAMODB_INDEX_READ_CAPACITY_UNITS
  }
  case object `dynamodb:index:WriteCapacityUnits`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.DYNAMODB_INDEX_WRITE_CAPACITY_UNITS
  }
  case object `rds:cluster:ReadReplicaCount`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.RDS_CLUSTER_READ_REPLICA_COUNT
  }
  case object `sagemaker:variant:DesiredInstanceCount`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.SAGEMAKER_VARIANT_DESIRED_INSTANCE_COUNT
  }
  case object `custom-resource:ResourceType:Property`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.CUSTOM_RESOURCE_RESOURCE_TYPE_PROPERTY
  }
  case object `comprehend:document-classifier-endpoint:DesiredInferenceUnits`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.COMPREHEND_DOCUMENT_CLASSIFIER_ENDPOINT_DESIRED_INFERENCE_UNITS
  }
  case object `comprehend:entity-recognizer-endpoint:DesiredInferenceUnits`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.COMPREHEND_ENTITY_RECOGNIZER_ENDPOINT_DESIRED_INFERENCE_UNITS
  }
  case object `lambda:function:ProvisionedConcurrency`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.LAMBDA_FUNCTION_PROVISIONED_CONCURRENCY
  }
  case object `cassandra:table:ReadCapacityUnits`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.CASSANDRA_TABLE_READ_CAPACITY_UNITS
  }
  case object `cassandra:table:WriteCapacityUnits`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.CASSANDRA_TABLE_WRITE_CAPACITY_UNITS
  }
  case object `kafka:broker-storage:VolumeSize`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.KAFKA_BROKER_STORAGE_VOLUME_SIZE
  }
  case object `elasticache:replication-group:NodeGroups`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.ELASTICACHE_REPLICATION_GROUP_NODE_GROUPS
  }
  case object `elasticache:replication-group:Replicas`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.ELASTICACHE_REPLICATION_GROUP_REPLICAS
  }
  case object `neptune:cluster:ReadReplicaCount`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.NEPTUNE_CLUSTER_READ_REPLICA_COUNT
  }
  case object `sagemaker:variant:DesiredProvisionedConcurrency`
      extends zio.aws.applicationautoscaling.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalableDimension.SAGEMAKER_VARIANT_DESIRED_PROVISIONED_CONCURRENCY
  }
}
