package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RegisterScalableTargetResponse(
    scalableTargetARN: Optional[XmlString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetResponse = {
    import RegisterScalableTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetResponse
      .builder()
      .optionallyWith(
        scalableTargetARN.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.scalableTargetARN)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.RegisterScalableTargetResponse.ReadOnly =
    zio.aws.applicationautoscaling.model.RegisterScalableTargetResponse
      .wrap(buildAwsValue())
}
object RegisterScalableTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.RegisterScalableTargetResponse =
      zio.aws.applicationautoscaling.model
        .RegisterScalableTargetResponse(scalableTargetARN.map(value => value))
    def scalableTargetARN: Optional[XmlString]
    def getScalableTargetARN: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("scalableTargetARN", scalableTargetARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetResponse
  ) extends zio.aws.applicationautoscaling.model.RegisterScalableTargetResponse.ReadOnly {
    override val scalableTargetARN: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.scalableTargetARN())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.XmlString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetResponse
  ): zio.aws.applicationautoscaling.model.RegisterScalableTargetResponse.ReadOnly =
    new Wrapper(impl)
}
