package zio.aws.applicationautoscaling.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.applicationautoscaling.model.primitives.{
  IncludeNotScaledActivities,
  XmlString,
  MaxResults,
  ResourceIdMaxLen1600
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeScalingActivitiesRequest(
    serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace,
    resourceId: Optional[ResourceIdMaxLen1600] = Optional.Absent,
    scalableDimension: Optional[
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[XmlString] = Optional.Absent,
    includeNotScaledActivities: Optional[IncludeNotScaledActivities] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest = {
    import DescribeScalingActivitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest
      .builder()
      .serviceNamespace(serviceNamespace.unwrap)
      .optionallyWith(
        resourceId.map(value =>
          ResourceIdMaxLen1600.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(scalableDimension.map(value => value.unwrap))(
        _.scalableDimension
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        includeNotScaledActivities.map(value =>
          IncludeNotScaledActivities.unwrap(value): java.lang.Boolean
        )
      )(_.includeNotScaledActivities)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.DescribeScalingActivitiesRequest.ReadOnly =
    zio.aws.applicationautoscaling.model.DescribeScalingActivitiesRequest
      .wrap(buildAwsValue())
}
object DescribeScalingActivitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.DescribeScalingActivitiesRequest =
      zio.aws.applicationautoscaling.model.DescribeScalingActivitiesRequest(
        serviceNamespace,
        resourceId.map(value => value),
        scalableDimension.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        includeNotScaledActivities.map(value => value)
      )
    def serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace
    def resourceId: Optional[ResourceIdMaxLen1600]
    def scalableDimension
        : Optional[zio.aws.applicationautoscaling.model.ScalableDimension]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[XmlString]
    def includeNotScaledActivities: Optional[IncludeNotScaledActivities]
    def getServiceNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ServiceNamespace
    ] = ZIO.succeed(serviceNamespace)
    def getResourceId: ZIO[Any, AwsError, ResourceIdMaxLen1600] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getScalableDimension: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = AwsError.unwrapOptionField("scalableDimension", scalableDimension)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIncludeNotScaledActivities
        : ZIO[Any, AwsError, IncludeNotScaledActivities] =
      AwsError.unwrapOptionField(
        "includeNotScaledActivities",
        includeNotScaledActivities
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest
  ) extends zio.aws.applicationautoscaling.model.DescribeScalingActivitiesRequest.ReadOnly {
    override val serviceNamespace
        : zio.aws.applicationautoscaling.model.ServiceNamespace =
      zio.aws.applicationautoscaling.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val resourceId: Optional[ResourceIdMaxLen1600] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceId())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives
            .ResourceIdMaxLen1600(value)
        )
    override val scalableDimension
        : Optional[zio.aws.applicationautoscaling.model.ScalableDimension] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalableDimension())
        .map(value =>
          zio.aws.applicationautoscaling.model.ScalableDimension.wrap(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.XmlString(value)
      )
    override val includeNotScaledActivities
        : Optional[IncludeNotScaledActivities] = zio.aws.core.internal
      .optionalFromNullable(impl.includeNotScaledActivities())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives
          .IncludeNotScaledActivities(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest
  ): zio.aws.applicationautoscaling.model.DescribeScalingActivitiesRequest.ReadOnly =
    new Wrapper(impl)
}
