package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Alarm(alarmName: ResourceId, alarmARN: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.Alarm = {
    import Alarm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.Alarm
      .builder()
      .alarmName(ResourceId.unwrap(alarmName): java.lang.String)
      .alarmARN(ResourceId.unwrap(alarmARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.applicationautoscaling.model.Alarm.ReadOnly =
    zio.aws.applicationautoscaling.model.Alarm.wrap(buildAwsValue())
}
object Alarm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.Alarm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationautoscaling.model.Alarm =
      zio.aws.applicationautoscaling.model.Alarm(alarmName, alarmARN)
    def alarmName: ResourceId
    def alarmARN: ResourceId
    def getAlarmName: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(alarmName)
    def getAlarmARN: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(alarmARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.Alarm
  ) extends zio.aws.applicationautoscaling.model.Alarm.ReadOnly {
    override val alarmName: ResourceId =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceId(impl.alarmName())
    override val alarmARN: ResourceId =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceId(impl.alarmARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.Alarm
  ): zio.aws.applicationautoscaling.model.Alarm.ReadOnly = new Wrapper(impl)
}
