package zio.aws.applicationautoscaling.model
import scala.jdk.CollectionConverters.*
sealed trait PolicyType {
  def unwrap
      : software.amazon.awssdk.services.applicationautoscaling.model.PolicyType
}
object PolicyType {
  def wrap(
      value: software.amazon.awssdk.services.applicationautoscaling.model.PolicyType
  ): zio.aws.applicationautoscaling.model.PolicyType = value match {
    case software.amazon.awssdk.services.applicationautoscaling.model.PolicyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.PolicyType.STEP_SCALING =>
      val r = StepScaling
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.PolicyType.TARGET_TRACKING_SCALING =>
      val r = TargetTrackingScaling
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationautoscaling.model.PolicyType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.PolicyType =
      software.amazon.awssdk.services.applicationautoscaling.model.PolicyType.UNKNOWN_TO_SDK_VERSION
  }
  case object StepScaling
      extends zio.aws.applicationautoscaling.model.PolicyType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.PolicyType =
      software.amazon.awssdk.services.applicationautoscaling.model.PolicyType.STEP_SCALING
  }
  case object TargetTrackingScaling
      extends zio.aws.applicationautoscaling.model.PolicyType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.PolicyType =
      software.amazon.awssdk.services.applicationautoscaling.model.PolicyType.TARGET_TRACKING_SCALING
  }
}
