package zio.aws.applicationautoscaling.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.applicationautoscaling.model.primitives.{
  TagValue,
  TagKey,
  ResourceCapacity,
  ResourceIdMaxLen1600
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RegisterScalableTargetRequest(
    serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: zio.aws.applicationautoscaling.model.ScalableDimension,
    minCapacity: Optional[ResourceCapacity] = Optional.Absent,
    maxCapacity: Optional[ResourceCapacity] = Optional.Absent,
    roleARN: Optional[ResourceIdMaxLen1600] = Optional.Absent,
    suspendedState: Optional[
      zio.aws.applicationautoscaling.model.SuspendedState
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetRequest = {
    import RegisterScalableTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetRequest
      .builder()
      .serviceNamespace(serviceNamespace.unwrap)
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .optionallyWith(
        minCapacity.map(value => ResourceCapacity.unwrap(value): Integer)
      )(_.minCapacity)
      .optionallyWith(
        maxCapacity.map(value => ResourceCapacity.unwrap(value): Integer)
      )(_.maxCapacity)
      .optionallyWith(
        roleARN.map(value =>
          ResourceIdMaxLen1600.unwrap(value): java.lang.String
        )
      )(_.roleARN)
      .optionallyWith(suspendedState.map(value => value.buildAwsValue()))(
        _.suspendedState
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.RegisterScalableTargetRequest.ReadOnly =
    zio.aws.applicationautoscaling.model.RegisterScalableTargetRequest
      .wrap(buildAwsValue())
}
object RegisterScalableTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.RegisterScalableTargetRequest =
      zio.aws.applicationautoscaling.model.RegisterScalableTargetRequest(
        serviceNamespace,
        resourceId,
        scalableDimension,
        minCapacity.map(value => value),
        maxCapacity.map(value => value),
        roleARN.map(value => value),
        suspendedState.map(value => value.asEditable),
        tags.map(value => value)
      )
    def serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension
    def minCapacity: Optional[ResourceCapacity]
    def maxCapacity: Optional[ResourceCapacity]
    def roleARN: Optional[ResourceIdMaxLen1600]
    def suspendedState
        : Optional[zio.aws.applicationautoscaling.model.SuspendedState.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getServiceNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ServiceNamespace
    ] = ZIO.succeed(serviceNamespace)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = ZIO.succeed(scalableDimension)
    def getMinCapacity: ZIO[Any, AwsError, ResourceCapacity] =
      AwsError.unwrapOptionField("minCapacity", minCapacity)
    def getMaxCapacity: ZIO[Any, AwsError, ResourceCapacity] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
    def getRoleARN: ZIO[Any, AwsError, ResourceIdMaxLen1600] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getSuspendedState: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.SuspendedState.ReadOnly
    ] = AwsError.unwrapOptionField("suspendedState", suspendedState)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetRequest
  ) extends zio.aws.applicationautoscaling.model.RegisterScalableTargetRequest.ReadOnly {
    override val serviceNamespace
        : zio.aws.applicationautoscaling.model.ServiceNamespace =
      zio.aws.applicationautoscaling.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension =
      zio.aws.applicationautoscaling.model.ScalableDimension
        .wrap(impl.scalableDimension())
    override val minCapacity: Optional[ResourceCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.minCapacity())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.ResourceCapacity(value)
      )
    override val maxCapacity: Optional[ResourceCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.maxCapacity())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.ResourceCapacity(value)
      )
    override val roleARN: Optional[ResourceIdMaxLen1600] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives
          .ResourceIdMaxLen1600(value)
      )
    override val suspendedState: Optional[
      zio.aws.applicationautoscaling.model.SuspendedState.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.suspendedState())
      .map(value =>
        zio.aws.applicationautoscaling.model.SuspendedState.wrap(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.applicationautoscaling.model.primitives.TagKey(
              key
            ) -> zio.aws.applicationautoscaling.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.RegisterScalableTargetRequest
  ): zio.aws.applicationautoscaling.model.RegisterScalableTargetRequest.ReadOnly =
    new Wrapper(impl)
}
