package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeScheduledActionsResponse(
    scheduledActions: Optional[
      Iterable[zio.aws.applicationautoscaling.model.ScheduledAction]
    ] = Optional.Absent,
    nextToken: Optional[XmlString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse = {
    import DescribeScheduledActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse
      .builder()
      .optionallyWith(
        scheduledActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scheduledActions)
      .optionallyWith(
        nextToken.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse.ReadOnly =
    zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse
      .wrap(buildAwsValue())
}
object DescribeScheduledActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse =
      zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse(
        scheduledActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scheduledActions: Optional[
      List[zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly]
    ]
    def nextToken: Optional[XmlString]
    def getScheduledActions: ZIO[Any, AwsError, List[
      zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly
    ]] = AwsError.unwrapOptionField("scheduledActions", scheduledActions)
    def getNextToken: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse
  ) extends zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse.ReadOnly {
    override val scheduledActions: Optional[
      List[zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationautoscaling.model.ScheduledAction.wrap(item)
        }.toList
      )
    override val nextToken: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.XmlString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse
  ): zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse.ReadOnly =
    new Wrapper(impl)
}
