package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.ScalingSuspended
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SuspendedState(
    dynamicScalingInSuspended: Optional[ScalingSuspended] = Optional.Absent,
    dynamicScalingOutSuspended: Optional[ScalingSuspended] = Optional.Absent,
    scheduledScalingSuspended: Optional[ScalingSuspended] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.SuspendedState = {
    import SuspendedState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.SuspendedState
      .builder()
      .optionallyWith(
        dynamicScalingInSuspended.map(value =>
          ScalingSuspended.unwrap(value): java.lang.Boolean
        )
      )(_.dynamicScalingInSuspended)
      .optionallyWith(
        dynamicScalingOutSuspended.map(value =>
          ScalingSuspended.unwrap(value): java.lang.Boolean
        )
      )(_.dynamicScalingOutSuspended)
      .optionallyWith(
        scheduledScalingSuspended.map(value =>
          ScalingSuspended.unwrap(value): java.lang.Boolean
        )
      )(_.scheduledScalingSuspended)
      .build()
  }
  def asReadOnly: zio.aws.applicationautoscaling.model.SuspendedState.ReadOnly =
    zio.aws.applicationautoscaling.model.SuspendedState.wrap(buildAwsValue())
}
object SuspendedState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.SuspendedState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationautoscaling.model.SuspendedState =
      zio.aws.applicationautoscaling.model.SuspendedState(
        dynamicScalingInSuspended.map(value => value),
        dynamicScalingOutSuspended.map(value => value),
        scheduledScalingSuspended.map(value => value)
      )
    def dynamicScalingInSuspended: Optional[ScalingSuspended]
    def dynamicScalingOutSuspended: Optional[ScalingSuspended]
    def scheduledScalingSuspended: Optional[ScalingSuspended]
    def getDynamicScalingInSuspended: ZIO[Any, AwsError, ScalingSuspended] =
      AwsError.unwrapOptionField(
        "dynamicScalingInSuspended",
        dynamicScalingInSuspended
      )
    def getDynamicScalingOutSuspended: ZIO[Any, AwsError, ScalingSuspended] =
      AwsError.unwrapOptionField(
        "dynamicScalingOutSuspended",
        dynamicScalingOutSuspended
      )
    def getScheduledScalingSuspended: ZIO[Any, AwsError, ScalingSuspended] =
      AwsError.unwrapOptionField(
        "scheduledScalingSuspended",
        scheduledScalingSuspended
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.SuspendedState
  ) extends zio.aws.applicationautoscaling.model.SuspendedState.ReadOnly {
    override val dynamicScalingInSuspended: Optional[ScalingSuspended] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dynamicScalingInSuspended())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives
            .ScalingSuspended(value)
        )
    override val dynamicScalingOutSuspended: Optional[ScalingSuspended] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dynamicScalingOutSuspended())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives
            .ScalingSuspended(value)
        )
    override val scheduledScalingSuspended: Optional[ScalingSuspended] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledScalingSuspended())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives
            .ScalingSuspended(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.SuspendedState
  ): zio.aws.applicationautoscaling.model.SuspendedState.ReadOnly = new Wrapper(
    impl
  )
}
