package zio.aws.applicationautoscaling.model
import scala.jdk.CollectionConverters.*
sealed trait ServiceNamespace {
  def unwrap: software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace
}
object ServiceNamespace {
  def wrap(
      value: software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace
  ): zio.aws.applicationautoscaling.model.ServiceNamespace = value match {
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.ECS =>
      val r = ecs
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.ELASTICMAPREDUCE =>
      val r = elasticmapreduce
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.EC2 =>
      val r = ec2
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.APPSTREAM =>
      val r = appstream
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.DYNAMODB =>
      val r = dynamodb
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.RDS =>
      val r = rds
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.SAGEMAKER =>
      val r = sagemaker
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.CUSTOM_RESOURCE =>
      val r = `custom-resource`
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.COMPREHEND =>
      val r = comprehend
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.LAMBDA =>
      val r = lambda
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.CASSANDRA =>
      val r = cassandra
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.KAFKA =>
      val r = kafka
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.ELASTICACHE =>
      val r = elasticache
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.NEPTUNE =>
      val r = neptune
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.UNKNOWN_TO_SDK_VERSION
  }
  case object ecs
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.ECS
  }
  case object elasticmapreduce
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.ELASTICMAPREDUCE
  }
  case object ec2
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.EC2
  }
  case object appstream
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.APPSTREAM
  }
  case object dynamodb
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.DYNAMODB
  }
  case object rds
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.RDS
  }
  case object sagemaker
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.SAGEMAKER
  }
  case object `custom-resource`
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.CUSTOM_RESOURCE
  }
  case object comprehend
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.COMPREHEND
  }
  case object lambda
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.LAMBDA
  }
  case object cassandra
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.CASSANDRA
  }
  case object kafka
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.KAFKA
  }
  case object elasticache
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.ELASTICACHE
  }
  case object neptune
      extends zio.aws.applicationautoscaling.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace =
      software.amazon.awssdk.services.applicationautoscaling.model.ServiceNamespace.NEPTUNE
  }
}
