package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.ResourceIdMaxLen1600
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteScheduledActionRequest(
    serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace,
    scheduledActionName: ResourceIdMaxLen1600,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: zio.aws.applicationautoscaling.model.ScalableDimension
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.DeleteScheduledActionRequest = {
    import DeleteScheduledActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.DeleteScheduledActionRequest
      .builder()
      .serviceNamespace(serviceNamespace.unwrap)
      .scheduledActionName(
        ResourceIdMaxLen1600.unwrap(scheduledActionName): java.lang.String
      )
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.DeleteScheduledActionRequest.ReadOnly =
    zio.aws.applicationautoscaling.model.DeleteScheduledActionRequest
      .wrap(buildAwsValue())
}
object DeleteScheduledActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.DeleteScheduledActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.DeleteScheduledActionRequest =
      zio.aws.applicationautoscaling.model.DeleteScheduledActionRequest(
        serviceNamespace,
        scheduledActionName,
        resourceId,
        scalableDimension
      )
    def serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace
    def scheduledActionName: ResourceIdMaxLen1600
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension
    def getServiceNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ServiceNamespace
    ] = ZIO.succeed(serviceNamespace)
    def getScheduledActionName: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(scheduledActionName)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = ZIO.succeed(scalableDimension)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DeleteScheduledActionRequest
  ) extends zio.aws.applicationautoscaling.model.DeleteScheduledActionRequest.ReadOnly {
    override val serviceNamespace
        : zio.aws.applicationautoscaling.model.ServiceNamespace =
      zio.aws.applicationautoscaling.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val scheduledActionName: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.scheduledActionName())
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension =
      zio.aws.applicationautoscaling.model.ScalableDimension
        .wrap(impl.scalableDimension())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DeleteScheduledActionRequest
  ): zio.aws.applicationautoscaling.model.DeleteScheduledActionRequest.ReadOnly =
    new Wrapper(impl)
}
