package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.{
  TargetTrackingMetricDimensionValue,
  TargetTrackingMetricDimensionName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TargetTrackingMetricDimension(
    name: TargetTrackingMetricDimensionName,
    value: TargetTrackingMetricDimensionValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricDimension = {
    import TargetTrackingMetricDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricDimension
      .builder()
      .name(TargetTrackingMetricDimensionName.unwrap(name): java.lang.String)
      .value(TargetTrackingMetricDimensionValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.TargetTrackingMetricDimension.ReadOnly =
    zio.aws.applicationautoscaling.model.TargetTrackingMetricDimension
      .wrap(buildAwsValue())
}
object TargetTrackingMetricDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.TargetTrackingMetricDimension =
      zio.aws.applicationautoscaling.model
        .TargetTrackingMetricDimension(name, value)
    def name: TargetTrackingMetricDimensionName
    def value: TargetTrackingMetricDimensionValue
    def getName: ZIO[Any, Nothing, TargetTrackingMetricDimensionName] =
      ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, TargetTrackingMetricDimensionValue] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricDimension
  ) extends zio.aws.applicationautoscaling.model.TargetTrackingMetricDimension.ReadOnly {
    override val name: TargetTrackingMetricDimensionName =
      zio.aws.applicationautoscaling.model.primitives
        .TargetTrackingMetricDimensionName(impl.name())
    override val value: TargetTrackingMetricDimensionValue =
      zio.aws.applicationautoscaling.model.primitives
        .TargetTrackingMetricDimensionValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingMetricDimension
  ): zio.aws.applicationautoscaling.model.TargetTrackingMetricDimension.ReadOnly =
    new Wrapper(impl)
}
