package zio.aws.applicationautoscaling.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.applicationautoscaling.model.primitives.{
  TimestampType,
  XmlString,
  ResourceIdMaxLen1600,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class ScalingActivity(
    activityId: ResourceId,
    serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: zio.aws.applicationautoscaling.model.ScalableDimension,
    description: XmlString,
    cause: XmlString,
    startTime: TimestampType,
    endTime: Optional[TimestampType] = Optional.Absent,
    statusCode: zio.aws.applicationautoscaling.model.ScalingActivityStatusCode,
    statusMessage: Optional[XmlString] = Optional.Absent,
    details: Optional[XmlString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity = {
    import ScalingActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity
      .builder()
      .activityId(ResourceId.unwrap(activityId): java.lang.String)
      .serviceNamespace(serviceNamespace.unwrap)
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .description(XmlString.unwrap(description): java.lang.String)
      .cause(XmlString.unwrap(cause): java.lang.String)
      .startTime(TimestampType.unwrap(startTime): Instant)
      .optionallyWith(
        endTime.map(value => TimestampType.unwrap(value): Instant)
      )(_.endTime)
      .statusCode(statusCode.unwrap)
      .optionallyWith(
        statusMessage.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.statusMessage)
      .optionallyWith(
        details.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.details)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly =
    zio.aws.applicationautoscaling.model.ScalingActivity.wrap(buildAwsValue())
}
object ScalingActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationautoscaling.model.ScalingActivity =
      zio.aws.applicationautoscaling.model.ScalingActivity(
        activityId,
        serviceNamespace,
        resourceId,
        scalableDimension,
        description,
        cause,
        startTime,
        endTime.map(value => value),
        statusCode,
        statusMessage.map(value => value),
        details.map(value => value)
      )
    def activityId: ResourceId
    def serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension
    def description: XmlString
    def cause: XmlString
    def startTime: TimestampType
    def endTime: Optional[TimestampType]
    def statusCode
        : zio.aws.applicationautoscaling.model.ScalingActivityStatusCode
    def statusMessage: Optional[XmlString]
    def details: Optional[XmlString]
    def getActivityId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(activityId)
    def getServiceNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ServiceNamespace
    ] = ZIO.succeed(serviceNamespace)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = ZIO.succeed(scalableDimension)
    def getDescription: ZIO[Any, Nothing, XmlString] = ZIO.succeed(description)
    def getCause: ZIO[Any, Nothing, XmlString] = ZIO.succeed(cause)
    def getStartTime: ZIO[Any, Nothing, TimestampType] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStatusCode: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ScalingActivityStatusCode
    ] = ZIO.succeed(statusCode)
    def getStatusMessage: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getDetails: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity
  ) extends zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly {
    override val activityId: ResourceId =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceId(impl.activityId())
    override val serviceNamespace
        : zio.aws.applicationautoscaling.model.ServiceNamespace =
      zio.aws.applicationautoscaling.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension =
      zio.aws.applicationautoscaling.model.ScalableDimension
        .wrap(impl.scalableDimension())
    override val description: XmlString =
      zio.aws.applicationautoscaling.model.primitives
        .XmlString(impl.description())
    override val cause: XmlString =
      zio.aws.applicationautoscaling.model.primitives.XmlString(impl.cause())
    override val startTime: TimestampType =
      zio.aws.applicationautoscaling.model.primitives
        .TimestampType(impl.startTime())
    override val endTime: Optional[TimestampType] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.TimestampType(value)
      )
    override val statusCode
        : zio.aws.applicationautoscaling.model.ScalingActivityStatusCode =
      zio.aws.applicationautoscaling.model.ScalingActivityStatusCode
        .wrap(impl.statusCode())
    override val statusMessage: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.XmlString(value)
      )
    override val details: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.details())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.XmlString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity
  ): zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly =
    new Wrapper(impl)
}
