package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.{
  ResourceIdMaxLen1600,
  PolicyName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutScalingPolicyRequest(
    policyName: PolicyName,
    serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: zio.aws.applicationautoscaling.model.ScalableDimension,
    policyType: Optional[zio.aws.applicationautoscaling.model.PolicyType] =
      Optional.Absent,
    stepScalingPolicyConfiguration: Optional[
      zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration
    ] = Optional.Absent,
    targetTrackingScalingPolicyConfiguration: Optional[
      zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyRequest = {
    import PutScalingPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyRequest
      .builder()
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .serviceNamespace(serviceNamespace.unwrap)
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .optionallyWith(policyType.map(value => value.unwrap))(_.policyType)
      .optionallyWith(
        stepScalingPolicyConfiguration.map(value => value.buildAwsValue())
      )(_.stepScalingPolicyConfiguration)
      .optionallyWith(
        targetTrackingScalingPolicyConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.targetTrackingScalingPolicyConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.PutScalingPolicyRequest.ReadOnly =
    zio.aws.applicationautoscaling.model.PutScalingPolicyRequest
      .wrap(buildAwsValue())
}
object PutScalingPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.PutScalingPolicyRequest =
      zio.aws.applicationautoscaling.model.PutScalingPolicyRequest(
        policyName,
        serviceNamespace,
        resourceId,
        scalableDimension,
        policyType.map(value => value),
        stepScalingPolicyConfiguration.map(value => value.asEditable),
        targetTrackingScalingPolicyConfiguration.map(value => value.asEditable)
      )
    def policyName: PolicyName
    def serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension
    def policyType: Optional[zio.aws.applicationautoscaling.model.PolicyType]
    def stepScalingPolicyConfiguration: Optional[
      zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration.ReadOnly
    ]
    def targetTrackingScalingPolicyConfiguration: Optional[
      zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration.ReadOnly
    ]
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getServiceNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ServiceNamespace
    ] = ZIO.succeed(serviceNamespace)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = ZIO.succeed(scalableDimension)
    def getPolicyType
        : ZIO[Any, AwsError, zio.aws.applicationautoscaling.model.PolicyType] =
      AwsError.unwrapOptionField("policyType", policyType)
    def getStepScalingPolicyConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "stepScalingPolicyConfiguration",
      stepScalingPolicyConfiguration
    )
    def getTargetTrackingScalingPolicyConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetTrackingScalingPolicyConfiguration",
      targetTrackingScalingPolicyConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyRequest
  ) extends zio.aws.applicationautoscaling.model.PutScalingPolicyRequest.ReadOnly {
    override val policyName: PolicyName =
      zio.aws.applicationautoscaling.model.primitives
        .PolicyName(impl.policyName())
    override val serviceNamespace
        : zio.aws.applicationautoscaling.model.ServiceNamespace =
      zio.aws.applicationautoscaling.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension =
      zio.aws.applicationautoscaling.model.ScalableDimension
        .wrap(impl.scalableDimension())
    override val policyType
        : Optional[zio.aws.applicationautoscaling.model.PolicyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyType())
        .map(value =>
          zio.aws.applicationautoscaling.model.PolicyType.wrap(value)
        )
    override val stepScalingPolicyConfiguration: Optional[
      zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stepScalingPolicyConfiguration())
      .map(value =>
        zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration
          .wrap(value)
      )
    override val targetTrackingScalingPolicyConfiguration: Optional[
      zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetTrackingScalingPolicyConfiguration())
      .map(value =>
        zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyRequest
  ): zio.aws.applicationautoscaling.model.PutScalingPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
