package zio.aws.applicationautoscaling.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.applicationautoscaling.model.primitives.{
  ScalingAdjustment,
  MetricScale
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StepAdjustment(
    metricIntervalLowerBound: Optional[MetricScale] = Optional.Absent,
    metricIntervalUpperBound: Optional[MetricScale] = Optional.Absent,
    scalingAdjustment: ScalingAdjustment
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.StepAdjustment = {
    import StepAdjustment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.StepAdjustment
      .builder()
      .optionallyWith(
        metricIntervalLowerBound.map(value =>
          MetricScale.unwrap(value): java.lang.Double
        )
      )(_.metricIntervalLowerBound)
      .optionallyWith(
        metricIntervalUpperBound.map(value =>
          MetricScale.unwrap(value): java.lang.Double
        )
      )(_.metricIntervalUpperBound)
      .scalingAdjustment(ScalingAdjustment.unwrap(scalingAdjustment): Integer)
      .build()
  }
  def asReadOnly: zio.aws.applicationautoscaling.model.StepAdjustment.ReadOnly =
    zio.aws.applicationautoscaling.model.StepAdjustment.wrap(buildAwsValue())
}
object StepAdjustment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.StepAdjustment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationautoscaling.model.StepAdjustment =
      zio.aws.applicationautoscaling.model.StepAdjustment(
        metricIntervalLowerBound.map(value => value),
        metricIntervalUpperBound.map(value => value),
        scalingAdjustment
      )
    def metricIntervalLowerBound: Optional[MetricScale]
    def metricIntervalUpperBound: Optional[MetricScale]
    def scalingAdjustment: ScalingAdjustment
    def getMetricIntervalLowerBound: ZIO[Any, AwsError, MetricScale] = AwsError
      .unwrapOptionField("metricIntervalLowerBound", metricIntervalLowerBound)
    def getMetricIntervalUpperBound: ZIO[Any, AwsError, MetricScale] = AwsError
      .unwrapOptionField("metricIntervalUpperBound", metricIntervalUpperBound)
    def getScalingAdjustment: ZIO[Any, Nothing, ScalingAdjustment] =
      ZIO.succeed(scalingAdjustment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.StepAdjustment
  ) extends zio.aws.applicationautoscaling.model.StepAdjustment.ReadOnly {
    override val metricIntervalLowerBound: Optional[MetricScale] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricIntervalLowerBound())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives.MetricScale(value)
        )
    override val metricIntervalUpperBound: Optional[MetricScale] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricIntervalUpperBound())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives.MetricScale(value)
        )
    override val scalingAdjustment: ScalingAdjustment =
      zio.aws.applicationautoscaling.model.primitives
        .ScalingAdjustment(impl.scalingAdjustment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.StepAdjustment
  ): zio.aws.applicationautoscaling.model.StepAdjustment.ReadOnly = new Wrapper(
    impl
  )
}
