package zio.aws.applicationautoscaling.model
import scala.jdk.CollectionConverters.*
sealed trait ScalingActivityStatusCode {
  def unwrap: software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode
}
object ScalingActivityStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode
  ): zio.aws.applicationautoscaling.model.ScalingActivityStatusCode =
    value match {
      case software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.PENDING =>
        val r = Pending
        r
      case software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.IN_PROGRESS =>
        val r = InProgress
        r
      case software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.SUCCESSFUL =>
        val r = Successful
        r
      case software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.OVERRIDDEN =>
        val r = Overridden
        r
      case software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.UNFULFILLED =>
        val r = Unfulfilled
        r
      case software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.FAILED =>
        val r = Failed
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.applicationautoscaling.model.ScalingActivityStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending
      extends zio.aws.applicationautoscaling.model.ScalingActivityStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.PENDING
  }
  case object InProgress
      extends zio.aws.applicationautoscaling.model.ScalingActivityStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.IN_PROGRESS
  }
  case object Successful
      extends zio.aws.applicationautoscaling.model.ScalingActivityStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.SUCCESSFUL
  }
  case object Overridden
      extends zio.aws.applicationautoscaling.model.ScalingActivityStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.OVERRIDDEN
  }
  case object Unfulfilled
      extends zio.aws.applicationautoscaling.model.ScalingActivityStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.UNFULFILLED
  }
  case object Failed
      extends zio.aws.applicationautoscaling.model.ScalingActivityStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode =
      software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivityStatusCode.FAILED
  }
}
