package zio.aws.applicationautoscaling.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.applicationautoscaling.model.primitives.ResourceCapacity
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ScalableTargetAction(
    minCapacity: Optional[ResourceCapacity] = Optional.Absent,
    maxCapacity: Optional[ResourceCapacity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetAction = {
    import ScalableTargetAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetAction
      .builder()
      .optionallyWith(
        minCapacity.map(value => ResourceCapacity.unwrap(value): Integer)
      )(_.minCapacity)
      .optionallyWith(
        maxCapacity.map(value => ResourceCapacity.unwrap(value): Integer)
      )(_.maxCapacity)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly =
    zio.aws.applicationautoscaling.model.ScalableTargetAction
      .wrap(buildAwsValue())
}
object ScalableTargetAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationautoscaling.model.ScalableTargetAction =
      zio.aws.applicationautoscaling.model.ScalableTargetAction(
        minCapacity.map(value => value),
        maxCapacity.map(value => value)
      )
    def minCapacity: Optional[ResourceCapacity]
    def maxCapacity: Optional[ResourceCapacity]
    def getMinCapacity: ZIO[Any, AwsError, ResourceCapacity] =
      AwsError.unwrapOptionField("minCapacity", minCapacity)
    def getMaxCapacity: ZIO[Any, AwsError, ResourceCapacity] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetAction
  ) extends zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly {
    override val minCapacity: Optional[ResourceCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.minCapacity())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.ResourceCapacity(value)
      )
    override val maxCapacity: Optional[ResourceCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.maxCapacity())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.ResourceCapacity(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetAction
  ): zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly =
    new Wrapper(impl)
}
