package zio.aws.applicationautoscaling.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.applicationautoscaling.model.primitives.{
  TimestampType,
  ScheduledActionName,
  ResourceIdMaxLen1600
}
import scala.jdk.CollectionConverters.*
final case class PutScheduledActionRequest(
    serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace,
    schedule: Optional[ResourceIdMaxLen1600] = Optional.Absent,
    timezone: Optional[ResourceIdMaxLen1600] = Optional.Absent,
    scheduledActionName: ScheduledActionName,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: zio.aws.applicationautoscaling.model.ScalableDimension,
    startTime: Optional[TimestampType] = Optional.Absent,
    endTime: Optional[TimestampType] = Optional.Absent,
    scalableTargetAction: Optional[
      zio.aws.applicationautoscaling.model.ScalableTargetAction
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionRequest = {
    import PutScheduledActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionRequest
      .builder()
      .serviceNamespace(serviceNamespace.unwrap)
      .optionallyWith(
        schedule.map(value =>
          ResourceIdMaxLen1600.unwrap(value): java.lang.String
        )
      )(_.schedule)
      .optionallyWith(
        timezone.map(value =>
          ResourceIdMaxLen1600.unwrap(value): java.lang.String
        )
      )(_.timezone)
      .scheduledActionName(
        ScheduledActionName.unwrap(scheduledActionName): java.lang.String
      )
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .optionallyWith(
        startTime.map(value => TimestampType.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => TimestampType.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(scalableTargetAction.map(value => value.buildAwsValue()))(
        _.scalableTargetAction
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.PutScheduledActionRequest.ReadOnly =
    zio.aws.applicationautoscaling.model.PutScheduledActionRequest
      .wrap(buildAwsValue())
}
object PutScheduledActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.PutScheduledActionRequest =
      zio.aws.applicationautoscaling.model.PutScheduledActionRequest(
        serviceNamespace,
        schedule.map(value => value),
        timezone.map(value => value),
        scheduledActionName,
        resourceId,
        scalableDimension,
        startTime.map(value => value),
        endTime.map(value => value),
        scalableTargetAction.map(value => value.asEditable)
      )
    def serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace
    def schedule: Optional[ResourceIdMaxLen1600]
    def timezone: Optional[ResourceIdMaxLen1600]
    def scheduledActionName: ScheduledActionName
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension
    def startTime: Optional[TimestampType]
    def endTime: Optional[TimestampType]
    def scalableTargetAction: Optional[
      zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly
    ]
    def getServiceNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ServiceNamespace
    ] = ZIO.succeed(serviceNamespace)
    def getSchedule: ZIO[Any, AwsError, ResourceIdMaxLen1600] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getTimezone: ZIO[Any, AwsError, ResourceIdMaxLen1600] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getScheduledActionName: ZIO[Any, Nothing, ScheduledActionName] =
      ZIO.succeed(scheduledActionName)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = ZIO.succeed(scalableDimension)
    def getStartTime: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getScalableTargetAction: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly
    ] = AwsError.unwrapOptionField("scalableTargetAction", scalableTargetAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionRequest
  ) extends zio.aws.applicationautoscaling.model.PutScheduledActionRequest.ReadOnly {
    override val serviceNamespace
        : zio.aws.applicationautoscaling.model.ServiceNamespace =
      zio.aws.applicationautoscaling.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val schedule: Optional[ResourceIdMaxLen1600] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives
            .ResourceIdMaxLen1600(value)
        )
    override val timezone: Optional[ResourceIdMaxLen1600] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timezone())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives
            .ResourceIdMaxLen1600(value)
        )
    override val scheduledActionName: ScheduledActionName =
      zio.aws.applicationautoscaling.model.primitives
        .ScheduledActionName(impl.scheduledActionName())
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension =
      zio.aws.applicationautoscaling.model.ScalableDimension
        .wrap(impl.scalableDimension())
    override val startTime: Optional[TimestampType] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.TimestampType(value)
      )
    override val endTime: Optional[TimestampType] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.TimestampType(value)
      )
    override val scalableTargetAction: Optional[
      zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scalableTargetAction())
      .map(value =>
        zio.aws.applicationautoscaling.model.ScalableTargetAction.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionRequest
  ): zio.aws.applicationautoscaling.model.PutScheduledActionRequest.ReadOnly =
    new Wrapper(impl)
}
