package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.ResourceLabel
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PredefinedMetricSpecification(
    predefinedMetricType: zio.aws.applicationautoscaling.model.MetricType,
    resourceLabel: Optional[ResourceLabel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.PredefinedMetricSpecification = {
    import PredefinedMetricSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.PredefinedMetricSpecification
      .builder()
      .predefinedMetricType(predefinedMetricType.unwrap)
      .optionallyWith(
        resourceLabel.map(value =>
          ResourceLabel.unwrap(value): java.lang.String
        )
      )(_.resourceLabel)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.PredefinedMetricSpecification.ReadOnly =
    zio.aws.applicationautoscaling.model.PredefinedMetricSpecification
      .wrap(buildAwsValue())
}
object PredefinedMetricSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.PredefinedMetricSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.PredefinedMetricSpecification =
      zio.aws.applicationautoscaling.model.PredefinedMetricSpecification(
        predefinedMetricType,
        resourceLabel.map(value => value)
      )
    def predefinedMetricType: zio.aws.applicationautoscaling.model.MetricType
    def resourceLabel: Optional[ResourceLabel]
    def getPredefinedMetricType
        : ZIO[Any, Nothing, zio.aws.applicationautoscaling.model.MetricType] =
      ZIO.succeed(predefinedMetricType)
    def getResourceLabel: ZIO[Any, AwsError, ResourceLabel] =
      AwsError.unwrapOptionField("resourceLabel", resourceLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.PredefinedMetricSpecification
  ) extends zio.aws.applicationautoscaling.model.PredefinedMetricSpecification.ReadOnly {
    override val predefinedMetricType
        : zio.aws.applicationautoscaling.model.MetricType =
      zio.aws.applicationautoscaling.model.MetricType
        .wrap(impl.predefinedMetricType())
    override val resourceLabel: Optional[ResourceLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceLabel())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.ResourceLabel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.PredefinedMetricSpecification
  ): zio.aws.applicationautoscaling.model.PredefinedMetricSpecification.ReadOnly =
    new Wrapper(impl)
}
