package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.ResourceIdMaxLen1600
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeregisterScalableTargetRequest(
    serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: zio.aws.applicationautoscaling.model.ScalableDimension
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.DeregisterScalableTargetRequest = {
    import DeregisterScalableTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.DeregisterScalableTargetRequest
      .builder()
      .serviceNamespace(serviceNamespace.unwrap)
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.DeregisterScalableTargetRequest.ReadOnly =
    zio.aws.applicationautoscaling.model.DeregisterScalableTargetRequest
      .wrap(buildAwsValue())
}
object DeregisterScalableTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.DeregisterScalableTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.DeregisterScalableTargetRequest =
      zio.aws.applicationautoscaling.model.DeregisterScalableTargetRequest(
        serviceNamespace,
        resourceId,
        scalableDimension
      )
    def serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension
    def getServiceNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ServiceNamespace
    ] = ZIO.succeed(serviceNamespace)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = ZIO.succeed(scalableDimension)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DeregisterScalableTargetRequest
  ) extends zio.aws.applicationautoscaling.model.DeregisterScalableTargetRequest.ReadOnly {
    override val serviceNamespace
        : zio.aws.applicationautoscaling.model.ServiceNamespace =
      zio.aws.applicationautoscaling.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension =
      zio.aws.applicationautoscaling.model.ScalableDimension
        .wrap(impl.scalableDimension())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DeregisterScalableTargetRequest
  ): zio.aws.applicationautoscaling.model.DeregisterScalableTargetRequest.ReadOnly =
    new Wrapper(impl)
}
