package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeScalingActivitiesResponse(
    scalingActivities: Optional[
      Iterable[zio.aws.applicationautoscaling.model.ScalingActivity]
    ] = Optional.Absent,
    nextToken: Optional[XmlString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse = {
    import DescribeScalingActivitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse
      .builder()
      .optionallyWith(
        scalingActivities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scalingActivities)
      .optionallyWith(
        nextToken.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse.ReadOnly =
    zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse
      .wrap(buildAwsValue())
}
object DescribeScalingActivitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse =
      zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse(
        scalingActivities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scalingActivities: Optional[
      List[zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly]
    ]
    def nextToken: Optional[XmlString]
    def getScalingActivities: ZIO[Any, AwsError, List[
      zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly
    ]] = AwsError.unwrapOptionField("scalingActivities", scalingActivities)
    def getNextToken: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse
  ) extends zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse.ReadOnly {
    override val scalingActivities: Optional[
      List[zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scalingActivities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationautoscaling.model.ScalingActivity.wrap(item)
        }.toList
      )
    override val nextToken: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.XmlString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse
  ): zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse.ReadOnly =
    new Wrapper(impl)
}
