package zio.aws.applicationautoscaling.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.applicationautoscaling.model.primitives.{
  TimestampType,
  ResourceIdMaxLen1600,
  ScheduledActionName
}
import scala.jdk.CollectionConverters.*
final case class ScheduledAction(
    scheduledActionName: ScheduledActionName,
    scheduledActionARN: ResourceIdMaxLen1600,
    serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace,
    schedule: ResourceIdMaxLen1600,
    timezone: Optional[ResourceIdMaxLen1600] = Optional.Absent,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: Optional[
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = Optional.Absent,
    startTime: Optional[TimestampType] = Optional.Absent,
    endTime: Optional[TimestampType] = Optional.Absent,
    scalableTargetAction: Optional[
      zio.aws.applicationautoscaling.model.ScalableTargetAction
    ] = Optional.Absent,
    creationTime: TimestampType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.ScheduledAction = {
    import ScheduledAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.ScheduledAction
      .builder()
      .scheduledActionName(
        ScheduledActionName.unwrap(scheduledActionName): java.lang.String
      )
      .scheduledActionARN(
        ResourceIdMaxLen1600.unwrap(scheduledActionARN): java.lang.String
      )
      .serviceNamespace(serviceNamespace.unwrap)
      .schedule(ResourceIdMaxLen1600.unwrap(schedule): java.lang.String)
      .optionallyWith(
        timezone.map(value =>
          ResourceIdMaxLen1600.unwrap(value): java.lang.String
        )
      )(_.timezone)
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .optionallyWith(scalableDimension.map(value => value.unwrap))(
        _.scalableDimension
      )
      .optionallyWith(
        startTime.map(value => TimestampType.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => TimestampType.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(scalableTargetAction.map(value => value.buildAwsValue()))(
        _.scalableTargetAction
      )
      .creationTime(TimestampType.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly =
    zio.aws.applicationautoscaling.model.ScheduledAction.wrap(buildAwsValue())
}
object ScheduledAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.ScheduledAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationautoscaling.model.ScheduledAction =
      zio.aws.applicationautoscaling.model.ScheduledAction(
        scheduledActionName,
        scheduledActionARN,
        serviceNamespace,
        schedule,
        timezone.map(value => value),
        resourceId,
        scalableDimension.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        scalableTargetAction.map(value => value.asEditable),
        creationTime
      )
    def scheduledActionName: ScheduledActionName
    def scheduledActionARN: ResourceIdMaxLen1600
    def serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace
    def schedule: ResourceIdMaxLen1600
    def timezone: Optional[ResourceIdMaxLen1600]
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension
        : Optional[zio.aws.applicationautoscaling.model.ScalableDimension]
    def startTime: Optional[TimestampType]
    def endTime: Optional[TimestampType]
    def scalableTargetAction: Optional[
      zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly
    ]
    def creationTime: TimestampType
    def getScheduledActionName: ZIO[Any, Nothing, ScheduledActionName] =
      ZIO.succeed(scheduledActionName)
    def getScheduledActionARN: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(scheduledActionARN)
    def getServiceNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ServiceNamespace
    ] = ZIO.succeed(serviceNamespace)
    def getSchedule: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(schedule)
    def getTimezone: ZIO[Any, AwsError, ResourceIdMaxLen1600] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = AwsError.unwrapOptionField("scalableDimension", scalableDimension)
    def getStartTime: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getScalableTargetAction: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly
    ] = AwsError.unwrapOptionField("scalableTargetAction", scalableTargetAction)
    def getCreationTime: ZIO[Any, Nothing, TimestampType] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.ScheduledAction
  ) extends zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly {
    override val scheduledActionName: ScheduledActionName =
      zio.aws.applicationautoscaling.model.primitives
        .ScheduledActionName(impl.scheduledActionName())
    override val scheduledActionARN: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.scheduledActionARN())
    override val serviceNamespace
        : zio.aws.applicationautoscaling.model.ServiceNamespace =
      zio.aws.applicationautoscaling.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val schedule: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.schedule())
    override val timezone: Optional[ResourceIdMaxLen1600] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timezone())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives
            .ResourceIdMaxLen1600(value)
        )
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : Optional[zio.aws.applicationautoscaling.model.ScalableDimension] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalableDimension())
        .map(value =>
          zio.aws.applicationautoscaling.model.ScalableDimension.wrap(value)
        )
    override val startTime: Optional[TimestampType] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.TimestampType(value)
      )
    override val endTime: Optional[TimestampType] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.TimestampType(value)
      )
    override val scalableTargetAction: Optional[
      zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scalableTargetAction())
      .map(value =>
        zio.aws.applicationautoscaling.model.ScalableTargetAction.wrap(value)
      )
    override val creationTime: TimestampType =
      zio.aws.applicationautoscaling.model.primitives
        .TimestampType(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.ScheduledAction
  ): zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly =
    new Wrapper(impl)
}
