package zio.aws.applicationautoscaling.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.applicationautoscaling.model.primitives.{
  TimestampType,
  ResourceCapacity,
  ResourceIdMaxLen1600
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ScalableTarget(
    serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: zio.aws.applicationautoscaling.model.ScalableDimension,
    minCapacity: ResourceCapacity,
    maxCapacity: ResourceCapacity,
    roleARN: ResourceIdMaxLen1600,
    creationTime: TimestampType,
    suspendedState: Optional[
      zio.aws.applicationautoscaling.model.SuspendedState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.ScalableTarget = {
    import ScalableTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.ScalableTarget
      .builder()
      .serviceNamespace(serviceNamespace.unwrap)
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .minCapacity(ResourceCapacity.unwrap(minCapacity): Integer)
      .maxCapacity(ResourceCapacity.unwrap(maxCapacity): Integer)
      .roleARN(ResourceIdMaxLen1600.unwrap(roleARN): java.lang.String)
      .creationTime(TimestampType.unwrap(creationTime): Instant)
      .optionallyWith(suspendedState.map(value => value.buildAwsValue()))(
        _.suspendedState
      )
      .build()
  }
  def asReadOnly: zio.aws.applicationautoscaling.model.ScalableTarget.ReadOnly =
    zio.aws.applicationautoscaling.model.ScalableTarget.wrap(buildAwsValue())
}
object ScalableTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.ScalableTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationautoscaling.model.ScalableTarget =
      zio.aws.applicationautoscaling.model.ScalableTarget(
        serviceNamespace,
        resourceId,
        scalableDimension,
        minCapacity,
        maxCapacity,
        roleARN,
        creationTime,
        suspendedState.map(value => value.asEditable)
      )
    def serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension
    def minCapacity: ResourceCapacity
    def maxCapacity: ResourceCapacity
    def roleARN: ResourceIdMaxLen1600
    def creationTime: TimestampType
    def suspendedState
        : Optional[zio.aws.applicationautoscaling.model.SuspendedState.ReadOnly]
    def getServiceNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ServiceNamespace
    ] = ZIO.succeed(serviceNamespace)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = ZIO.succeed(scalableDimension)
    def getMinCapacity: ZIO[Any, Nothing, ResourceCapacity] =
      ZIO.succeed(minCapacity)
    def getMaxCapacity: ZIO[Any, Nothing, ResourceCapacity] =
      ZIO.succeed(maxCapacity)
    def getRoleARN: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(roleARN)
    def getCreationTime: ZIO[Any, Nothing, TimestampType] =
      ZIO.succeed(creationTime)
    def getSuspendedState: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.SuspendedState.ReadOnly
    ] = AwsError.unwrapOptionField("suspendedState", suspendedState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.ScalableTarget
  ) extends zio.aws.applicationautoscaling.model.ScalableTarget.ReadOnly {
    override val serviceNamespace
        : zio.aws.applicationautoscaling.model.ServiceNamespace =
      zio.aws.applicationautoscaling.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension =
      zio.aws.applicationautoscaling.model.ScalableDimension
        .wrap(impl.scalableDimension())
    override val minCapacity: ResourceCapacity =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceCapacity(impl.minCapacity())
    override val maxCapacity: ResourceCapacity =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceCapacity(impl.maxCapacity())
    override val roleARN: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.roleARN())
    override val creationTime: TimestampType =
      zio.aws.applicationautoscaling.model.primitives
        .TimestampType(impl.creationTime())
    override val suspendedState: Optional[
      zio.aws.applicationautoscaling.model.SuspendedState.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.suspendedState())
      .map(value =>
        zio.aws.applicationautoscaling.model.SuspendedState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.ScalableTarget
  ): zio.aws.applicationautoscaling.model.ScalableTarget.ReadOnly = new Wrapper(
    impl
  )
}
