package zio.aws.applicationautoscaling.model
import scala.jdk.CollectionConverters.*
sealed trait MetricStatistic {
  def unwrap: software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic
}
object MetricStatistic {
  def wrap(
      value: software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic
  ): zio.aws.applicationautoscaling.model.MetricStatistic = value match {
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic.AVERAGE =>
      val r = Average
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic.MINIMUM =>
      val r = Minimum
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic.MAXIMUM =>
      val r = Maximum
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic.SAMPLE_COUNT =>
      val r = SampleCount
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic.SUM =>
      val r = Sum
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationautoscaling.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic.UNKNOWN_TO_SDK_VERSION
  }
  case object Average
      extends zio.aws.applicationautoscaling.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic.AVERAGE
  }
  case object Minimum
      extends zio.aws.applicationautoscaling.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic.MINIMUM
  }
  case object Maximum
      extends zio.aws.applicationautoscaling.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic.MAXIMUM
  }
  case object SampleCount
      extends zio.aws.applicationautoscaling.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic.SAMPLE_COUNT
  }
  case object Sum extends zio.aws.applicationautoscaling.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricStatistic.SUM
  }
}
