package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeScalingPoliciesResponse(
    scalingPolicies: Optional[
      Iterable[zio.aws.applicationautoscaling.model.ScalingPolicy]
    ] = Optional.Absent,
    nextToken: Optional[XmlString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesResponse = {
    import DescribeScalingPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesResponse
      .builder()
      .optionallyWith(
        scalingPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scalingPolicies)
      .optionallyWith(
        nextToken.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.DescribeScalingPoliciesResponse.ReadOnly =
    zio.aws.applicationautoscaling.model.DescribeScalingPoliciesResponse
      .wrap(buildAwsValue())
}
object DescribeScalingPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.DescribeScalingPoliciesResponse =
      zio.aws.applicationautoscaling.model.DescribeScalingPoliciesResponse(
        scalingPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scalingPolicies: Optional[
      List[zio.aws.applicationautoscaling.model.ScalingPolicy.ReadOnly]
    ]
    def nextToken: Optional[XmlString]
    def getScalingPolicies: ZIO[Any, AwsError, List[
      zio.aws.applicationautoscaling.model.ScalingPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("scalingPolicies", scalingPolicies)
    def getNextToken: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesResponse
  ) extends zio.aws.applicationautoscaling.model.DescribeScalingPoliciesResponse.ReadOnly {
    override val scalingPolicies: Optional[
      List[zio.aws.applicationautoscaling.model.ScalingPolicy.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scalingPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationautoscaling.model.ScalingPolicy.wrap(item)
        }.toList
      )
    override val nextToken: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.XmlString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingPoliciesResponse
  ): zio.aws.applicationautoscaling.model.DescribeScalingPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
