package zio.aws.applicationautoscaling.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.applicationautoscaling.model.primitives.{
  Cooldown,
  MinAdjustmentMagnitude
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StepScalingPolicyConfiguration(
    adjustmentType: Optional[
      zio.aws.applicationautoscaling.model.AdjustmentType
    ] = Optional.Absent,
    stepAdjustments: Optional[
      Iterable[zio.aws.applicationautoscaling.model.StepAdjustment]
    ] = Optional.Absent,
    minAdjustmentMagnitude: Optional[MinAdjustmentMagnitude] = Optional.Absent,
    cooldown: Optional[Cooldown] = Optional.Absent,
    metricAggregationType: Optional[
      zio.aws.applicationautoscaling.model.MetricAggregationType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.StepScalingPolicyConfiguration = {
    import StepScalingPolicyConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.StepScalingPolicyConfiguration
      .builder()
      .optionallyWith(adjustmentType.map(value => value.unwrap))(
        _.adjustmentType
      )
      .optionallyWith(
        stepAdjustments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stepAdjustments)
      .optionallyWith(
        minAdjustmentMagnitude.map(value =>
          MinAdjustmentMagnitude.unwrap(value): Integer
        )
      )(_.minAdjustmentMagnitude)
      .optionallyWith(cooldown.map(value => Cooldown.unwrap(value): Integer))(
        _.cooldown
      )
      .optionallyWith(metricAggregationType.map(value => value.unwrap))(
        _.metricAggregationType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration.ReadOnly =
    zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration
      .wrap(buildAwsValue())
}
object StepScalingPolicyConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.StepScalingPolicyConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration =
      zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration(
        adjustmentType.map(value => value),
        stepAdjustments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        minAdjustmentMagnitude.map(value => value),
        cooldown.map(value => value),
        metricAggregationType.map(value => value)
      )
    def adjustmentType
        : Optional[zio.aws.applicationautoscaling.model.AdjustmentType]
    def stepAdjustments: Optional[
      List[zio.aws.applicationautoscaling.model.StepAdjustment.ReadOnly]
    ]
    def minAdjustmentMagnitude: Optional[MinAdjustmentMagnitude]
    def cooldown: Optional[Cooldown]
    def metricAggregationType
        : Optional[zio.aws.applicationautoscaling.model.MetricAggregationType]
    def getAdjustmentType: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.AdjustmentType
    ] = AwsError.unwrapOptionField("adjustmentType", adjustmentType)
    def getStepAdjustments: ZIO[Any, AwsError, List[
      zio.aws.applicationautoscaling.model.StepAdjustment.ReadOnly
    ]] = AwsError.unwrapOptionField("stepAdjustments", stepAdjustments)
    def getMinAdjustmentMagnitude: ZIO[Any, AwsError, MinAdjustmentMagnitude] =
      AwsError.unwrapOptionField(
        "minAdjustmentMagnitude",
        minAdjustmentMagnitude
      )
    def getCooldown: ZIO[Any, AwsError, Cooldown] =
      AwsError.unwrapOptionField("cooldown", cooldown)
    def getMetricAggregationType: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.MetricAggregationType
    ] =
      AwsError.unwrapOptionField("metricAggregationType", metricAggregationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.StepScalingPolicyConfiguration
  ) extends zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration.ReadOnly {
    override val adjustmentType
        : Optional[zio.aws.applicationautoscaling.model.AdjustmentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adjustmentType())
        .map(value =>
          zio.aws.applicationautoscaling.model.AdjustmentType.wrap(value)
        )
    override val stepAdjustments: Optional[
      List[zio.aws.applicationautoscaling.model.StepAdjustment.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stepAdjustments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationautoscaling.model.StepAdjustment.wrap(item)
        }.toList
      )
    override val minAdjustmentMagnitude: Optional[MinAdjustmentMagnitude] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minAdjustmentMagnitude())
        .map(value =>
          zio.aws.applicationautoscaling.model.primitives
            .MinAdjustmentMagnitude(value)
        )
    override val cooldown: Optional[Cooldown] = zio.aws.core.internal
      .optionalFromNullable(impl.cooldown())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.Cooldown(value)
      )
    override val metricAggregationType
        : Optional[zio.aws.applicationautoscaling.model.MetricAggregationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricAggregationType())
        .map(value =>
          zio.aws.applicationautoscaling.model.MetricAggregationType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.StepScalingPolicyConfiguration
  ): zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration.ReadOnly =
    new Wrapper(impl)
}
