package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.{
  MetricDimensionValue,
  MetricDimensionName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MetricDimension(
    name: MetricDimensionName,
    value: MetricDimensionValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.MetricDimension = {
    import MetricDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.MetricDimension
      .builder()
      .name(MetricDimensionName.unwrap(name): java.lang.String)
      .value(MetricDimensionValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.MetricDimension.ReadOnly =
    zio.aws.applicationautoscaling.model.MetricDimension.wrap(buildAwsValue())
}
object MetricDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.MetricDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationautoscaling.model.MetricDimension =
      zio.aws.applicationautoscaling.model.MetricDimension(name, value)
    def name: MetricDimensionName
    def value: MetricDimensionValue
    def getName: ZIO[Any, Nothing, MetricDimensionName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, MetricDimensionValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.MetricDimension
  ) extends zio.aws.applicationautoscaling.model.MetricDimension.ReadOnly {
    override val name: MetricDimensionName =
      zio.aws.applicationautoscaling.model.primitives
        .MetricDimensionName(impl.name())
    override val value: MetricDimensionValue =
      zio.aws.applicationautoscaling.model.primitives
        .MetricDimensionValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.MetricDimension
  ): zio.aws.applicationautoscaling.model.MetricDimension.ReadOnly =
    new Wrapper(impl)
}
