package zio.aws.applicationautoscaling.model
import scala.jdk.CollectionConverters.*
sealed trait AdjustmentType {
  def unwrap: software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType
}
object AdjustmentType {
  def wrap(
      value: software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType
  ): zio.aws.applicationautoscaling.model.AdjustmentType = value match {
    case software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType.CHANGE_IN_CAPACITY =>
      val r = ChangeInCapacity
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType.PERCENT_CHANGE_IN_CAPACITY =>
      val r = PercentChangeInCapacity
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType.EXACT_CAPACITY =>
      val r = ExactCapacity
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationautoscaling.model.AdjustmentType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType =
      software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType.UNKNOWN_TO_SDK_VERSION
  }
  case object ChangeInCapacity
      extends zio.aws.applicationautoscaling.model.AdjustmentType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType =
      software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType.CHANGE_IN_CAPACITY
  }
  case object PercentChangeInCapacity
      extends zio.aws.applicationautoscaling.model.AdjustmentType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType =
      software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType.PERCENT_CHANGE_IN_CAPACITY
  }
  case object ExactCapacity
      extends zio.aws.applicationautoscaling.model.AdjustmentType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType =
      software.amazon.awssdk.services.applicationautoscaling.model.AdjustmentType.EXACT_CAPACITY
  }
}
