package zio.aws.applicationautoscaling.model
import scala.jdk.CollectionConverters.*
sealed trait MetricType {
  def unwrap
      : software.amazon.awssdk.services.applicationautoscaling.model.MetricType
}
object MetricType {
  def wrap(
      value: software.amazon.awssdk.services.applicationautoscaling.model.MetricType
  ): zio.aws.applicationautoscaling.model.MetricType = value match {
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.DYNAMO_DB_READ_CAPACITY_UTILIZATION =>
      val r = DynamoDBReadCapacityUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.DYNAMO_DB_WRITE_CAPACITY_UTILIZATION =>
      val r = DynamoDBWriteCapacityUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.ALB_REQUEST_COUNT_PER_TARGET =>
      val r = ALBRequestCountPerTarget
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.RDS_READER_AVERAGE_CPU_UTILIZATION =>
      val r = RDSReaderAverageCPUUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.RDS_READER_AVERAGE_DATABASE_CONNECTIONS =>
      val r = RDSReaderAverageDatabaseConnections
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION =>
      val r = EC2SpotFleetRequestAverageCPUUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN =>
      val r = EC2SpotFleetRequestAverageNetworkIn
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT =>
      val r = EC2SpotFleetRequestAverageNetworkOut
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.SAGE_MAKER_VARIANT_INVOCATIONS_PER_INSTANCE =>
      val r = SageMakerVariantInvocationsPerInstance
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.ECS_SERVICE_AVERAGE_CPU_UTILIZATION =>
      val r = ECSServiceAverageCPUUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION =>
      val r = ECSServiceAverageMemoryUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.APP_STREAM_AVERAGE_CAPACITY_UTILIZATION =>
      val r = AppStreamAverageCapacityUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.COMPREHEND_INFERENCE_UTILIZATION =>
      val r = ComprehendInferenceUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION =>
      val r = LambdaProvisionedConcurrencyUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.CASSANDRA_READ_CAPACITY_UTILIZATION =>
      val r = CassandraReadCapacityUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.CASSANDRA_WRITE_CAPACITY_UTILIZATION =>
      val r = CassandraWriteCapacityUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.KAFKA_BROKER_STORAGE_UTILIZATION =>
      val r = KafkaBrokerStorageUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.ELASTI_CACHE_PRIMARY_ENGINE_CPU_UTILIZATION =>
      val r = ElastiCachePrimaryEngineCPUUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.ELASTI_CACHE_REPLICA_ENGINE_CPU_UTILIZATION =>
      val r = ElastiCacheReplicaEngineCPUUtilization
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.ELASTI_CACHE_DATABASE_MEMORY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE =>
      val r = ElastiCacheDatabaseMemoryUsageCountedForEvictPercentage
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricType.NEPTUNE_READER_AVERAGE_CPU_UTILIZATION =>
      val r = NeptuneReaderAverageCPUUtilization
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.UNKNOWN_TO_SDK_VERSION
  }
  case object DynamoDBReadCapacityUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.DYNAMO_DB_READ_CAPACITY_UTILIZATION
  }
  case object DynamoDBWriteCapacityUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.DYNAMO_DB_WRITE_CAPACITY_UTILIZATION
  }
  case object ALBRequestCountPerTarget
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.ALB_REQUEST_COUNT_PER_TARGET
  }
  case object RDSReaderAverageCPUUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.RDS_READER_AVERAGE_CPU_UTILIZATION
  }
  case object RDSReaderAverageDatabaseConnections
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.RDS_READER_AVERAGE_DATABASE_CONNECTIONS
  }
  case object EC2SpotFleetRequestAverageCPUUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION
  }
  case object EC2SpotFleetRequestAverageNetworkIn
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN
  }
  case object EC2SpotFleetRequestAverageNetworkOut
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT
  }
  case object SageMakerVariantInvocationsPerInstance
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.SAGE_MAKER_VARIANT_INVOCATIONS_PER_INSTANCE
  }
  case object ECSServiceAverageCPUUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.ECS_SERVICE_AVERAGE_CPU_UTILIZATION
  }
  case object ECSServiceAverageMemoryUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION
  }
  case object AppStreamAverageCapacityUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.APP_STREAM_AVERAGE_CAPACITY_UTILIZATION
  }
  case object ComprehendInferenceUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.COMPREHEND_INFERENCE_UTILIZATION
  }
  case object LambdaProvisionedConcurrencyUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION
  }
  case object CassandraReadCapacityUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.CASSANDRA_READ_CAPACITY_UTILIZATION
  }
  case object CassandraWriteCapacityUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.CASSANDRA_WRITE_CAPACITY_UTILIZATION
  }
  case object KafkaBrokerStorageUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.KAFKA_BROKER_STORAGE_UTILIZATION
  }
  case object ElastiCachePrimaryEngineCPUUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.ELASTI_CACHE_PRIMARY_ENGINE_CPU_UTILIZATION
  }
  case object ElastiCacheReplicaEngineCPUUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.ELASTI_CACHE_REPLICA_ENGINE_CPU_UTILIZATION
  }
  case object ElastiCacheDatabaseMemoryUsageCountedForEvictPercentage
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.ELASTI_CACHE_DATABASE_MEMORY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE
  }
  case object NeptuneReaderAverageCPUUtilization
      extends zio.aws.applicationautoscaling.model.MetricType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricType.NEPTUNE_READER_AVERAGE_CPU_UTILIZATION
  }
}
