package zio.aws.applicationautoscaling.model
import scala.jdk.CollectionConverters.*
sealed trait MetricAggregationType {
  def unwrap: software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType
}
object MetricAggregationType {
  def wrap(
      value: software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType
  ): zio.aws.applicationautoscaling.model.MetricAggregationType = value match {
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType.AVERAGE =>
      val r = Average
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType.MINIMUM =>
      val r = Minimum
      r
    case software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType.MAXIMUM =>
      val r = Maximum
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationautoscaling.model.MetricAggregationType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType.UNKNOWN_TO_SDK_VERSION
  }
  case object Average
      extends zio.aws.applicationautoscaling.model.MetricAggregationType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType.AVERAGE
  }
  case object Minimum
      extends zio.aws.applicationautoscaling.model.MetricAggregationType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType.MINIMUM
  }
  case object Maximum
      extends zio.aws.applicationautoscaling.model.MetricAggregationType {
    override def unwrap
        : software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType =
      software.amazon.awssdk.services.applicationautoscaling.model.MetricAggregationType.MAXIMUM
  }
}
