package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeScalingActivitiesResponse(
    scalingActivities: Option[
      Iterable[zio.aws.applicationautoscaling.model.ScalingActivity]
    ] = None,
    nextToken: Option[XmlString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse = {
    import DescribeScalingActivitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse
      .builder()
      .optionallyWith(
        scalingActivities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scalingActivities)
      .optionallyWith(
        nextToken.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse.ReadOnly =
    zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse
      .wrap(buildAwsValue())
}
object DescribeScalingActivitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse =
      zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse(
        scalingActivities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scalingActivities: Option[
      List[zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly]
    ]
    def nextToken: Option[XmlString]
    def getScalingActivities: ZIO[Any, AwsError, List[
      zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly
    ]] = AwsError.unwrapOptionField("scalingActivities", scalingActivities)
    def getNextToken: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse
  ) extends zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse.ReadOnly {
    override val scalingActivities: Option[
      List[zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly]
    ] = scala
      .Option(impl.scalingActivities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationautoscaling.model.ScalingActivity.wrap(item)
        }.toList
      )
    override val nextToken: Option[XmlString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.XmlString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse
  ): zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse.ReadOnly =
    new Wrapper(impl)
}
