package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeScalableTargetsResponse(
    scalableTargets: Option[
      Iterable[zio.aws.applicationautoscaling.model.ScalableTarget]
    ] = None,
    nextToken: Option[XmlString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse = {
    import DescribeScalableTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse
      .builder()
      .optionallyWith(
        scalableTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scalableTargets)
      .optionallyWith(
        nextToken.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.DescribeScalableTargetsResponse.ReadOnly =
    zio.aws.applicationautoscaling.model.DescribeScalableTargetsResponse
      .wrap(buildAwsValue())
}
object DescribeScalableTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.DescribeScalableTargetsResponse =
      zio.aws.applicationautoscaling.model.DescribeScalableTargetsResponse(
        scalableTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scalableTargets: Option[
      List[zio.aws.applicationautoscaling.model.ScalableTarget.ReadOnly]
    ]
    def nextToken: Option[XmlString]
    def getScalableTargets: ZIO[Any, AwsError, List[
      zio.aws.applicationautoscaling.model.ScalableTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("scalableTargets", scalableTargets)
    def getNextToken: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse
  ) extends zio.aws.applicationautoscaling.model.DescribeScalableTargetsResponse.ReadOnly {
    override val scalableTargets: Option[
      List[zio.aws.applicationautoscaling.model.ScalableTarget.ReadOnly]
    ] = scala
      .Option(impl.scalableTargets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationautoscaling.model.ScalableTarget.wrap(item)
        }.toList
      )
    override val nextToken: Option[XmlString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.XmlString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse
  ): zio.aws.applicationautoscaling.model.DescribeScalableTargetsResponse.ReadOnly =
    new Wrapper(impl)
}
