package zio.aws.applicationautoscaling.model
import java.lang.Integer
import zio.aws.applicationautoscaling.model.primitives.{
  DisableScaleIn,
  Cooldown,
  MetricScale
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TargetTrackingScalingPolicyConfiguration(
    targetValue: MetricScale,
    predefinedMetricSpecification: Option[
      zio.aws.applicationautoscaling.model.PredefinedMetricSpecification
    ] = None,
    customizedMetricSpecification: Option[
      zio.aws.applicationautoscaling.model.CustomizedMetricSpecification
    ] = None,
    scaleOutCooldown: Option[Cooldown] = None,
    scaleInCooldown: Option[Cooldown] = None,
    disableScaleIn: Option[DisableScaleIn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration = {
    import TargetTrackingScalingPolicyConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
      .builder()
      .targetValue(MetricScale.unwrap(targetValue): java.lang.Double)
      .optionallyWith(
        predefinedMetricSpecification.map(value => value.buildAwsValue())
      )(_.predefinedMetricSpecification)
      .optionallyWith(
        customizedMetricSpecification.map(value => value.buildAwsValue())
      )(_.customizedMetricSpecification)
      .optionallyWith(
        scaleOutCooldown.map(value => Cooldown.unwrap(value): Integer)
      )(_.scaleOutCooldown)
      .optionallyWith(
        scaleInCooldown.map(value => Cooldown.unwrap(value): Integer)
      )(_.scaleInCooldown)
      .optionallyWith(
        disableScaleIn.map(value =>
          DisableScaleIn.unwrap(value): java.lang.Boolean
        )
      )(_.disableScaleIn)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration.ReadOnly =
    zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
      .wrap(buildAwsValue())
}
object TargetTrackingScalingPolicyConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration =
      zio.aws.applicationautoscaling.model
        .TargetTrackingScalingPolicyConfiguration(
          targetValue,
          predefinedMetricSpecification.map(value => value.asEditable),
          customizedMetricSpecification.map(value => value.asEditable),
          scaleOutCooldown.map(value => value),
          scaleInCooldown.map(value => value),
          disableScaleIn.map(value => value)
        )
    def targetValue: MetricScale
    def predefinedMetricSpecification: Option[
      zio.aws.applicationautoscaling.model.PredefinedMetricSpecification.ReadOnly
    ]
    def customizedMetricSpecification: Option[
      zio.aws.applicationautoscaling.model.CustomizedMetricSpecification.ReadOnly
    ]
    def scaleOutCooldown: Option[Cooldown]
    def scaleInCooldown: Option[Cooldown]
    def disableScaleIn: Option[DisableScaleIn]
    def getTargetValue: ZIO[Any, Nothing, MetricScale] =
      ZIO.succeed(targetValue)
    def getPredefinedMetricSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.PredefinedMetricSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "predefinedMetricSpecification",
      predefinedMetricSpecification
    )
    def getCustomizedMetricSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.CustomizedMetricSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customizedMetricSpecification",
      customizedMetricSpecification
    )
    def getScaleOutCooldown: ZIO[Any, AwsError, Cooldown] =
      AwsError.unwrapOptionField("scaleOutCooldown", scaleOutCooldown)
    def getScaleInCooldown: ZIO[Any, AwsError, Cooldown] =
      AwsError.unwrapOptionField("scaleInCooldown", scaleInCooldown)
    def getDisableScaleIn: ZIO[Any, AwsError, DisableScaleIn] =
      AwsError.unwrapOptionField("disableScaleIn", disableScaleIn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
  ) extends zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration.ReadOnly {
    override val targetValue: MetricScale =
      zio.aws.applicationautoscaling.model.primitives
        .MetricScale(impl.targetValue())
    override val predefinedMetricSpecification: Option[
      zio.aws.applicationautoscaling.model.PredefinedMetricSpecification.ReadOnly
    ] = scala
      .Option(impl.predefinedMetricSpecification())
      .map(value =>
        zio.aws.applicationautoscaling.model.PredefinedMetricSpecification
          .wrap(value)
      )
    override val customizedMetricSpecification: Option[
      zio.aws.applicationautoscaling.model.CustomizedMetricSpecification.ReadOnly
    ] = scala
      .Option(impl.customizedMetricSpecification())
      .map(value =>
        zio.aws.applicationautoscaling.model.CustomizedMetricSpecification
          .wrap(value)
      )
    override val scaleOutCooldown: Option[Cooldown] = scala
      .Option(impl.scaleOutCooldown())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.Cooldown(value)
      )
    override val scaleInCooldown: Option[Cooldown] = scala
      .Option(impl.scaleInCooldown())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.Cooldown(value)
      )
    override val disableScaleIn: Option[DisableScaleIn] = scala
      .Option(impl.disableScaleIn())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.DisableScaleIn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
  ): zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration.ReadOnly =
    new Wrapper(impl)
}
