package zio.aws.applicationautoscaling
import zio.aws.applicationautoscaling.model.DeregisterScalableTargetResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.applicationautoscaling.model.{
  DescribeScheduledActionsRequest,
  PutScheduledActionRequest,
  DeleteScalingPolicyRequest,
  PutScalingPolicyRequest,
  RegisterScalableTargetRequest,
  DeleteScheduledActionRequest,
  DescribeScalableTargetsRequest,
  DeregisterScalableTargetRequest,
  DescribeScalingActivitiesRequest,
  DescribeScalingPoliciesRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingAsyncClient
object ApplicationAutoScalingMock extends Mock[ApplicationAutoScaling] {
  object DescribeScalingActivities
      extends Stream[
        DescribeScalingActivitiesRequest,
        AwsError,
        zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly
      ]
  object DescribeScalingActivitiesPaginated
      extends Effect[
        DescribeScalingActivitiesRequest,
        AwsError,
        zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse.ReadOnly
      ]
  object PutScalingPolicy
      extends Effect[
        PutScalingPolicyRequest,
        AwsError,
        zio.aws.applicationautoscaling.model.PutScalingPolicyResponse.ReadOnly
      ]
  object DescribeScalingPolicies
      extends Stream[
        DescribeScalingPoliciesRequest,
        AwsError,
        zio.aws.applicationautoscaling.model.ScalingPolicy.ReadOnly
      ]
  object DescribeScalingPoliciesPaginated
      extends Effect[
        DescribeScalingPoliciesRequest,
        AwsError,
        zio.aws.applicationautoscaling.model.DescribeScalingPoliciesResponse.ReadOnly
      ]
  object RegisterScalableTarget
      extends Effect[
        RegisterScalableTargetRequest,
        AwsError,
        zio.aws.applicationautoscaling.model.RegisterScalableTargetResponse.ReadOnly
      ]
  object DeregisterScalableTarget
      extends Effect[DeregisterScalableTargetRequest, AwsError, ReadOnly]
  object DescribeScalableTargets
      extends Stream[
        DescribeScalableTargetsRequest,
        AwsError,
        zio.aws.applicationautoscaling.model.ScalableTarget.ReadOnly
      ]
  object DescribeScalableTargetsPaginated
      extends Effect[
        DescribeScalableTargetsRequest,
        AwsError,
        zio.aws.applicationautoscaling.model.DescribeScalableTargetsResponse.ReadOnly
      ]
  object DescribeScheduledActions
      extends Stream[
        DescribeScheduledActionsRequest,
        AwsError,
        zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly
      ]
  object DescribeScheduledActionsPaginated
      extends Effect[
        DescribeScheduledActionsRequest,
        AwsError,
        zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse.ReadOnly
      ]
  object DeleteScheduledAction
      extends Effect[
        DeleteScheduledActionRequest,
        AwsError,
        zio.aws.applicationautoscaling.model.DeleteScheduledActionResponse.ReadOnly
      ]
  object PutScheduledAction
      extends Effect[
        PutScheduledActionRequest,
        AwsError,
        zio.aws.applicationautoscaling.model.PutScheduledActionResponse.ReadOnly
      ]
  object DeleteScalingPolicy
      extends Effect[
        DeleteScalingPolicyRequest,
        AwsError,
        zio.aws.applicationautoscaling.model.DeleteScalingPolicyResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ApplicationAutoScaling] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new ApplicationAutoScaling {
          val api: ApplicationAutoScalingAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : ApplicationAutoScaling = this
          def describeScalingActivities(
              request: DescribeScalingActivitiesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeScalingActivities, request))
          def describeScalingActivitiesPaginated(
              request: DescribeScalingActivitiesRequest
          ): IO[
            AwsError,
            zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse.ReadOnly
          ] = proxy(DescribeScalingActivitiesPaginated, request)
          def putScalingPolicy(request: PutScalingPolicyRequest): IO[
            AwsError,
            zio.aws.applicationautoscaling.model.PutScalingPolicyResponse.ReadOnly
          ] = proxy(PutScalingPolicy, request)
          def describeScalingPolicies(
              request: DescribeScalingPoliciesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.applicationautoscaling.model.ScalingPolicy.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeScalingPolicies, request))
          def describeScalingPoliciesPaginated(
              request: DescribeScalingPoliciesRequest
          ): IO[
            AwsError,
            zio.aws.applicationautoscaling.model.DescribeScalingPoliciesResponse.ReadOnly
          ] = proxy(DescribeScalingPoliciesPaginated, request)
          def registerScalableTarget(
              request: RegisterScalableTargetRequest
          ): IO[
            AwsError,
            zio.aws.applicationautoscaling.model.RegisterScalableTargetResponse.ReadOnly
          ] = proxy(RegisterScalableTarget, request)
          def deregisterScalableTarget(
              request: DeregisterScalableTargetRequest
          ): IO[AwsError, ReadOnly] = proxy(DeregisterScalableTarget, request)
          def describeScalableTargets(
              request: DescribeScalableTargetsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.applicationautoscaling.model.ScalableTarget.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeScalableTargets, request))
          def describeScalableTargetsPaginated(
              request: DescribeScalableTargetsRequest
          ): IO[
            AwsError,
            zio.aws.applicationautoscaling.model.DescribeScalableTargetsResponse.ReadOnly
          ] = proxy(DescribeScalableTargetsPaginated, request)
          def describeScheduledActions(
              request: DescribeScheduledActionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeScheduledActions, request))
          def describeScheduledActionsPaginated(
              request: DescribeScheduledActionsRequest
          ): IO[
            AwsError,
            zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse.ReadOnly
          ] = proxy(DescribeScheduledActionsPaginated, request)
          def deleteScheduledAction(request: DeleteScheduledActionRequest): IO[
            AwsError,
            zio.aws.applicationautoscaling.model.DeleteScheduledActionResponse.ReadOnly
          ] = proxy(DeleteScheduledAction, request)
          def putScheduledAction(request: PutScheduledActionRequest): IO[
            AwsError,
            zio.aws.applicationautoscaling.model.PutScheduledActionResponse.ReadOnly
          ] = proxy(PutScheduledAction, request)
          def deleteScalingPolicy(request: DeleteScalingPolicyRequest): IO[
            AwsError,
            zio.aws.applicationautoscaling.model.DeleteScalingPolicyResponse.ReadOnly
          ] = proxy(DeleteScalingPolicy, request)
        }
      }
    }
    .toLayer
}
