package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.{
  MetricUnit,
  MetricNamespace,
  MetricName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CustomizedMetricSpecification(
    metricName: MetricName,
    namespace: MetricNamespace,
    dimensions: Option[
      Iterable[zio.aws.applicationautoscaling.model.MetricDimension]
    ] = None,
    statistic: zio.aws.applicationautoscaling.model.MetricStatistic,
    unit: Option[MetricUnit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.CustomizedMetricSpecification = {
    import CustomizedMetricSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.CustomizedMetricSpecification
      .builder()
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .namespace(MetricNamespace.unwrap(namespace): java.lang.String)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .statistic(statistic.unwrap)
      .optionallyWith(
        unit.map(value => MetricUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.CustomizedMetricSpecification.ReadOnly =
    zio.aws.applicationautoscaling.model.CustomizedMetricSpecification
      .wrap(buildAwsValue())
}
object CustomizedMetricSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.CustomizedMetricSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.CustomizedMetricSpecification =
      zio.aws.applicationautoscaling.model.CustomizedMetricSpecification(
        metricName,
        namespace,
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statistic,
        unit.map(value => value)
      )
    def metricName: MetricName
    def namespace: MetricNamespace
    def dimensions: Option[
      List[zio.aws.applicationautoscaling.model.MetricDimension.ReadOnly]
    ]
    def statistic: zio.aws.applicationautoscaling.model.MetricStatistic
    def unit: Option[MetricUnit]
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getNamespace: ZIO[Any, Nothing, MetricNamespace] =
      ZIO.succeed(namespace)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.applicationautoscaling.model.MetricDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getStatistic: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.MetricStatistic
    ] = ZIO.succeed(statistic)
    def getUnit: ZIO[Any, AwsError, MetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.CustomizedMetricSpecification
  ) extends zio.aws.applicationautoscaling.model.CustomizedMetricSpecification.ReadOnly {
    override val metricName: MetricName =
      zio.aws.applicationautoscaling.model.primitives
        .MetricName(impl.metricName())
    override val namespace: MetricNamespace =
      zio.aws.applicationautoscaling.model.primitives
        .MetricNamespace(impl.namespace())
    override val dimensions: Option[
      List[zio.aws.applicationautoscaling.model.MetricDimension.ReadOnly]
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationautoscaling.model.MetricDimension.wrap(item)
        }.toList
      )
    override val statistic
        : zio.aws.applicationautoscaling.model.MetricStatistic =
      zio.aws.applicationautoscaling.model.MetricStatistic
        .wrap(impl.statistic())
    override val unit: Option[MetricUnit] = scala
      .Option(impl.unit())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.MetricUnit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.CustomizedMetricSpecification
  ): zio.aws.applicationautoscaling.model.CustomizedMetricSpecification.ReadOnly =
    new Wrapper(impl)
}
