package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.ResourceIdMaxLen1600
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteScalingPolicyRequest(
    policyName: ResourceIdMaxLen1600,
    serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: zio.aws.applicationautoscaling.model.ScalableDimension
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.DeleteScalingPolicyRequest = {
    import DeleteScalingPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.DeleteScalingPolicyRequest
      .builder()
      .policyName(ResourceIdMaxLen1600.unwrap(policyName): java.lang.String)
      .serviceNamespace(serviceNamespace.unwrap)
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.DeleteScalingPolicyRequest.ReadOnly =
    zio.aws.applicationautoscaling.model.DeleteScalingPolicyRequest
      .wrap(buildAwsValue())
}
object DeleteScalingPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.DeleteScalingPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.DeleteScalingPolicyRequest =
      zio.aws.applicationautoscaling.model.DeleteScalingPolicyRequest(
        policyName,
        serviceNamespace,
        resourceId,
        scalableDimension
      )
    def policyName: ResourceIdMaxLen1600
    def serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension
    def getPolicyName: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(policyName)
    def getServiceNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ServiceNamespace
    ] = ZIO.succeed(serviceNamespace)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = ZIO.succeed(scalableDimension)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DeleteScalingPolicyRequest
  ) extends zio.aws.applicationautoscaling.model.DeleteScalingPolicyRequest.ReadOnly {
    override val policyName: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.policyName())
    override val serviceNamespace
        : zio.aws.applicationautoscaling.model.ServiceNamespace =
      zio.aws.applicationautoscaling.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension =
      zio.aws.applicationautoscaling.model.ScalableDimension
        .wrap(impl.scalableDimension())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DeleteScalingPolicyRequest
  ): zio.aws.applicationautoscaling.model.DeleteScalingPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
