package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.{
  TimestampType,
  PolicyName,
  ResourceIdMaxLen1600
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ScalingPolicy(
    policyARN: ResourceIdMaxLen1600,
    policyName: PolicyName,
    serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: zio.aws.applicationautoscaling.model.ScalableDimension,
    policyType: zio.aws.applicationautoscaling.model.PolicyType,
    stepScalingPolicyConfiguration: Option[
      zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration
    ] = None,
    targetTrackingScalingPolicyConfiguration: Option[
      zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
    ] = None,
    alarms: Option[Iterable[zio.aws.applicationautoscaling.model.Alarm]] = None,
    creationTime: TimestampType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.ScalingPolicy = {
    import ScalingPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.ScalingPolicy
      .builder()
      .policyARN(ResourceIdMaxLen1600.unwrap(policyARN): java.lang.String)
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .serviceNamespace(serviceNamespace.unwrap)
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .policyType(policyType.unwrap)
      .optionallyWith(
        stepScalingPolicyConfiguration.map(value => value.buildAwsValue())
      )(_.stepScalingPolicyConfiguration)
      .optionallyWith(
        targetTrackingScalingPolicyConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.targetTrackingScalingPolicyConfiguration)
      .optionallyWith(
        alarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alarms)
      .creationTime(TimestampType.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.applicationautoscaling.model.ScalingPolicy.ReadOnly =
    zio.aws.applicationautoscaling.model.ScalingPolicy.wrap(buildAwsValue())
}
object ScalingPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.ScalingPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationautoscaling.model.ScalingPolicy =
      zio.aws.applicationautoscaling.model.ScalingPolicy(
        policyARN,
        policyName,
        serviceNamespace,
        resourceId,
        scalableDimension,
        policyType,
        stepScalingPolicyConfiguration.map(value => value.asEditable),
        targetTrackingScalingPolicyConfiguration.map(value => value.asEditable),
        alarms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime
      )
    def policyARN: ResourceIdMaxLen1600
    def policyName: PolicyName
    def serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension
    def policyType: zio.aws.applicationautoscaling.model.PolicyType
    def stepScalingPolicyConfiguration: Option[
      zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration.ReadOnly
    ]
    def targetTrackingScalingPolicyConfiguration: Option[
      zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration.ReadOnly
    ]
    def alarms
        : Option[List[zio.aws.applicationautoscaling.model.Alarm.ReadOnly]]
    def creationTime: TimestampType
    def getPolicyARN: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(policyARN)
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getServiceNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ServiceNamespace
    ] = ZIO.succeed(serviceNamespace)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = ZIO.succeed(scalableDimension)
    def getPolicyType
        : ZIO[Any, Nothing, zio.aws.applicationautoscaling.model.PolicyType] =
      ZIO.succeed(policyType)
    def getStepScalingPolicyConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "stepScalingPolicyConfiguration",
      stepScalingPolicyConfiguration
    )
    def getTargetTrackingScalingPolicyConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetTrackingScalingPolicyConfiguration",
      targetTrackingScalingPolicyConfiguration
    )
    def getAlarms: ZIO[Any, AwsError, List[
      zio.aws.applicationautoscaling.model.Alarm.ReadOnly
    ]] = AwsError.unwrapOptionField("alarms", alarms)
    def getCreationTime: ZIO[Any, Nothing, TimestampType] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.ScalingPolicy
  ) extends zio.aws.applicationautoscaling.model.ScalingPolicy.ReadOnly {
    override val policyARN: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.policyARN())
    override val policyName: PolicyName =
      zio.aws.applicationautoscaling.model.primitives
        .PolicyName(impl.policyName())
    override val serviceNamespace
        : zio.aws.applicationautoscaling.model.ServiceNamespace =
      zio.aws.applicationautoscaling.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension =
      zio.aws.applicationautoscaling.model.ScalableDimension
        .wrap(impl.scalableDimension())
    override val policyType: zio.aws.applicationautoscaling.model.PolicyType =
      zio.aws.applicationautoscaling.model.PolicyType.wrap(impl.policyType())
    override val stepScalingPolicyConfiguration: Option[
      zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration.ReadOnly
    ] = scala
      .Option(impl.stepScalingPolicyConfiguration())
      .map(value =>
        zio.aws.applicationautoscaling.model.StepScalingPolicyConfiguration
          .wrap(value)
      )
    override val targetTrackingScalingPolicyConfiguration: Option[
      zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration.ReadOnly
    ] = scala
      .Option(impl.targetTrackingScalingPolicyConfiguration())
      .map(value =>
        zio.aws.applicationautoscaling.model.TargetTrackingScalingPolicyConfiguration
          .wrap(value)
      )
    override val alarms
        : Option[List[zio.aws.applicationautoscaling.model.Alarm.ReadOnly]] =
      scala
        .Option(impl.alarms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.applicationautoscaling.model.Alarm.wrap(item)
          }.toList
        )
    override val creationTime: TimestampType =
      zio.aws.applicationautoscaling.model.primitives
        .TimestampType(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.ScalingPolicy
  ): zio.aws.applicationautoscaling.model.ScalingPolicy.ReadOnly = new Wrapper(
    impl
  )
}
