package zio.aws.applicationautoscaling.model
import java.lang.Integer
import zio.aws.applicationautoscaling.model.primitives.ResourceCapacity
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ScalableTargetAction(
    minCapacity: Option[ResourceCapacity] = None,
    maxCapacity: Option[ResourceCapacity] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetAction = {
    import ScalableTargetAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetAction
      .builder()
      .optionallyWith(
        minCapacity.map(value => ResourceCapacity.unwrap(value): Integer)
      )(_.minCapacity)
      .optionallyWith(
        maxCapacity.map(value => ResourceCapacity.unwrap(value): Integer)
      )(_.maxCapacity)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly =
    zio.aws.applicationautoscaling.model.ScalableTargetAction
      .wrap(buildAwsValue())
}
object ScalableTargetAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationautoscaling.model.ScalableTargetAction =
      zio.aws.applicationautoscaling.model.ScalableTargetAction(
        minCapacity.map(value => value),
        maxCapacity.map(value => value)
      )
    def minCapacity: Option[ResourceCapacity]
    def maxCapacity: Option[ResourceCapacity]
    def getMinCapacity: ZIO[Any, AwsError, ResourceCapacity] =
      AwsError.unwrapOptionField("minCapacity", minCapacity)
    def getMaxCapacity: ZIO[Any, AwsError, ResourceCapacity] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetAction
  ) extends zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly {
    override val minCapacity: Option[ResourceCapacity] = scala
      .Option(impl.minCapacity())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.ResourceCapacity(value)
      )
    override val maxCapacity: Option[ResourceCapacity] = scala
      .Option(impl.maxCapacity())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.ResourceCapacity(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.ScalableTargetAction
  ): zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly =
    new Wrapper(impl)
}
