package zio.aws.applicationautoscaling
import zio.aws.applicationautoscaling.model.DeregisterScalableTargetResponse.ReadOnly
import software.amazon.awssdk.services.applicationautoscaling.model.{
  ScalingActivity,
  PutScalingPolicyResponse,
  DescribeScalingPoliciesResponse,
  DescribeScalingActivitiesResponse,
  DescribeScheduledActionsRequest,
  PutScheduledActionRequest,
  DescribeScheduledActionsResponse,
  ScalableTarget,
  DeleteScheduledActionResponse,
  DeleteScalingPolicyRequest,
  PutScalingPolicyRequest,
  RegisterScalableTargetRequest,
  ScalingPolicy,
  DeleteScheduledActionRequest,
  DeleteScalingPolicyResponse,
  DescribeScalableTargetsRequest,
  ScheduledAction,
  DeregisterScalableTargetRequest,
  DeregisterScalableTargetResponse,
  DescribeScalableTargetsResponse,
  PutScheduledActionResponse,
  RegisterScalableTargetResponse,
  DescribeScalingActivitiesRequest,
  DescribeScalingPoliciesRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.applicationautoscaling.{
  ApplicationAutoScalingAsyncClientBuilder,
  ApplicationAutoScalingAsyncClient
}
import scala.jdk.CollectionConverters.*
trait ApplicationAutoScaling extends AspectSupport[ApplicationAutoScaling] {
  val api: ApplicationAutoScalingAsyncClient
  def describeScalingActivities(
      request: zio.aws.applicationautoscaling.model.DescribeScalingActivitiesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly
  ]
  def describeScalingActivitiesPaginated(
      request: zio.aws.applicationautoscaling.model.DescribeScalingActivitiesRequest
  ): IO[
    AwsError,
    zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse.ReadOnly
  ]
  def putScalingPolicy(
      request: zio.aws.applicationautoscaling.model.PutScalingPolicyRequest
  ): IO[
    AwsError,
    zio.aws.applicationautoscaling.model.PutScalingPolicyResponse.ReadOnly
  ]
  def describeScalingPolicies(
      request: zio.aws.applicationautoscaling.model.DescribeScalingPoliciesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.applicationautoscaling.model.ScalingPolicy.ReadOnly
  ]
  def describeScalingPoliciesPaginated(
      request: zio.aws.applicationautoscaling.model.DescribeScalingPoliciesRequest
  ): IO[
    AwsError,
    zio.aws.applicationautoscaling.model.DescribeScalingPoliciesResponse.ReadOnly
  ]
  def registerScalableTarget(
      request: zio.aws.applicationautoscaling.model.RegisterScalableTargetRequest
  ): IO[
    AwsError,
    zio.aws.applicationautoscaling.model.RegisterScalableTargetResponse.ReadOnly
  ]
  def deregisterScalableTarget(
      request: zio.aws.applicationautoscaling.model.DeregisterScalableTargetRequest
  ): IO[AwsError, ReadOnly]
  def describeScalableTargets(
      request: zio.aws.applicationautoscaling.model.DescribeScalableTargetsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.applicationautoscaling.model.ScalableTarget.ReadOnly
  ]
  def describeScalableTargetsPaginated(
      request: zio.aws.applicationautoscaling.model.DescribeScalableTargetsRequest
  ): IO[
    AwsError,
    zio.aws.applicationautoscaling.model.DescribeScalableTargetsResponse.ReadOnly
  ]
  def describeScheduledActions(
      request: zio.aws.applicationautoscaling.model.DescribeScheduledActionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly
  ]
  def describeScheduledActionsPaginated(
      request: zio.aws.applicationautoscaling.model.DescribeScheduledActionsRequest
  ): IO[
    AwsError,
    zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse.ReadOnly
  ]
  def deleteScheduledAction(
      request: zio.aws.applicationautoscaling.model.DeleteScheduledActionRequest
  ): IO[
    AwsError,
    zio.aws.applicationautoscaling.model.DeleteScheduledActionResponse.ReadOnly
  ]
  def putScheduledAction(
      request: zio.aws.applicationautoscaling.model.PutScheduledActionRequest
  ): IO[
    AwsError,
    zio.aws.applicationautoscaling.model.PutScheduledActionResponse.ReadOnly
  ]
  def deleteScalingPolicy(
      request: zio.aws.applicationautoscaling.model.DeleteScalingPolicyRequest
  ): IO[
    AwsError,
    zio.aws.applicationautoscaling.model.DeleteScalingPolicyResponse.ReadOnly
  ]
}
object ApplicationAutoScaling {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ApplicationAutoScaling] =
    customized(identity)
  def customized(
      customization: ApplicationAutoScalingAsyncClientBuilder => ApplicationAutoScalingAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ApplicationAutoScaling] = managed(
    customization
  ).toLayer
  def managed(
      customization: ApplicationAutoScalingAsyncClientBuilder => ApplicationAutoScalingAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, ApplicationAutoScaling] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = ApplicationAutoScalingAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        ApplicationAutoScalingAsyncClient,
        ApplicationAutoScalingAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        ApplicationAutoScalingAsyncClient,
        ApplicationAutoScalingAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new ApplicationAutoScalingImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ApplicationAutoScalingImpl[R](
      override val api: ApplicationAutoScalingAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ApplicationAutoScaling
      with AwsServiceBase[R] {
    override val serviceName: String = "ApplicationAutoScaling"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ApplicationAutoScalingImpl[R1] =
      new ApplicationAutoScalingImpl(api, newAspect, r)
    def describeScalingActivities(
        request: zio.aws.applicationautoscaling.model.DescribeScalingActivitiesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeScalingActivitiesRequest,
      DescribeScalingActivitiesResponse,
      ScalingActivity
    ](
      "describeScalingActivities",
      api.describeScalingActivities,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.scalingActivities().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.applicationautoscaling.model.ScalingActivity.wrap(item)
      )
      .provideEnvironment(r)
    def describeScalingActivitiesPaginated(
        request: zio.aws.applicationautoscaling.model.DescribeScalingActivitiesRequest
    ): IO[
      AwsError,
      zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeScalingActivitiesRequest,
      DescribeScalingActivitiesResponse
    ]("describeScalingActivities", api.describeScalingActivities)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse.wrap
    ).provideEnvironment(r)
    def putScalingPolicy(
        request: zio.aws.applicationautoscaling.model.PutScalingPolicyRequest
    ): IO[
      AwsError,
      zio.aws.applicationautoscaling.model.PutScalingPolicyResponse.ReadOnly
    ] = asyncRequestResponse[PutScalingPolicyRequest, PutScalingPolicyResponse](
      "putScalingPolicy",
      api.putScalingPolicy
    )(request.buildAwsValue())
      .map(zio.aws.applicationautoscaling.model.PutScalingPolicyResponse.wrap)
      .provideEnvironment(r)
    def describeScalingPolicies(
        request: zio.aws.applicationautoscaling.model.DescribeScalingPoliciesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.ScalingPolicy.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeScalingPoliciesRequest,
      DescribeScalingPoliciesResponse,
      ScalingPolicy
    ](
      "describeScalingPolicies",
      api.describeScalingPolicies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.scalingPolicies().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.applicationautoscaling.model.ScalingPolicy.wrap(item)
      )
      .provideEnvironment(r)
    def describeScalingPoliciesPaginated(
        request: zio.aws.applicationautoscaling.model.DescribeScalingPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.applicationautoscaling.model.DescribeScalingPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeScalingPoliciesRequest,
      DescribeScalingPoliciesResponse
    ]("describeScalingPolicies", api.describeScalingPolicies)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationautoscaling.model.DescribeScalingPoliciesResponse.wrap
    ).provideEnvironment(r)
    def registerScalableTarget(
        request: zio.aws.applicationautoscaling.model.RegisterScalableTargetRequest
    ): IO[
      AwsError,
      zio.aws.applicationautoscaling.model.RegisterScalableTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterScalableTargetRequest,
      RegisterScalableTargetResponse
    ]("registerScalableTarget", api.registerScalableTarget)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationautoscaling.model.RegisterScalableTargetResponse.wrap
    ).provideEnvironment(r)
    def deregisterScalableTarget(
        request: zio.aws.applicationautoscaling.model.DeregisterScalableTargetRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      DeregisterScalableTargetRequest,
      DeregisterScalableTargetResponse
    ]("deregisterScalableTarget", api.deregisterScalableTarget)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationautoscaling.model.DeregisterScalableTargetResponse.wrap
    ).provideEnvironment(r)
    def describeScalableTargets(
        request: zio.aws.applicationautoscaling.model.DescribeScalableTargetsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.ScalableTarget.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeScalableTargetsRequest,
      DescribeScalableTargetsResponse,
      ScalableTarget
    ](
      "describeScalableTargets",
      api.describeScalableTargets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.scalableTargets().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.applicationautoscaling.model.ScalableTarget.wrap(item)
      )
      .provideEnvironment(r)
    def describeScalableTargetsPaginated(
        request: zio.aws.applicationautoscaling.model.DescribeScalableTargetsRequest
    ): IO[
      AwsError,
      zio.aws.applicationautoscaling.model.DescribeScalableTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeScalableTargetsRequest,
      DescribeScalableTargetsResponse
    ]("describeScalableTargets", api.describeScalableTargets)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationautoscaling.model.DescribeScalableTargetsResponse.wrap
    ).provideEnvironment(r)
    def describeScheduledActions(
        request: zio.aws.applicationautoscaling.model.DescribeScheduledActionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeScheduledActionsRequest,
      DescribeScheduledActionsResponse,
      ScheduledAction
    ](
      "describeScheduledActions",
      api.describeScheduledActions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.scheduledActions().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.applicationautoscaling.model.ScheduledAction.wrap(item)
      )
      .provideEnvironment(r)
    def describeScheduledActionsPaginated(
        request: zio.aws.applicationautoscaling.model.DescribeScheduledActionsRequest
    ): IO[
      AwsError,
      zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeScheduledActionsRequest,
      DescribeScheduledActionsResponse
    ]("describeScheduledActions", api.describeScheduledActions)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse.wrap
    ).provideEnvironment(r)
    def deleteScheduledAction(
        request: zio.aws.applicationautoscaling.model.DeleteScheduledActionRequest
    ): IO[
      AwsError,
      zio.aws.applicationautoscaling.model.DeleteScheduledActionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteScheduledActionRequest,
      DeleteScheduledActionResponse
    ]("deleteScheduledAction", api.deleteScheduledAction)(
      request.buildAwsValue()
    ).map(
      zio.aws.applicationautoscaling.model.DeleteScheduledActionResponse.wrap
    ).provideEnvironment(r)
    def putScheduledAction(
        request: zio.aws.applicationautoscaling.model.PutScheduledActionRequest
    ): IO[
      AwsError,
      zio.aws.applicationautoscaling.model.PutScheduledActionResponse.ReadOnly
    ] = asyncRequestResponse[
      PutScheduledActionRequest,
      PutScheduledActionResponse
    ]("putScheduledAction", api.putScheduledAction)(request.buildAwsValue())
      .map(zio.aws.applicationautoscaling.model.PutScheduledActionResponse.wrap)
      .provideEnvironment(r)
    def deleteScalingPolicy(
        request: zio.aws.applicationautoscaling.model.DeleteScalingPolicyRequest
    ): IO[
      AwsError,
      zio.aws.applicationautoscaling.model.DeleteScalingPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteScalingPolicyRequest,
      DeleteScalingPolicyResponse
    ]("deleteScalingPolicy", api.deleteScalingPolicy)(request.buildAwsValue())
      .map(
        zio.aws.applicationautoscaling.model.DeleteScalingPolicyResponse.wrap
      )
      .provideEnvironment(r)
  }
  def describeScalingActivities(
      request: zio.aws.applicationautoscaling.model.DescribeScalingActivitiesRequest
  ): ZStream[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    zio.aws.applicationautoscaling.model.ScalingActivity.ReadOnly
  ] = ZStream.serviceWithStream(_.describeScalingActivities(request))
  def describeScalingActivitiesPaginated(
      request: zio.aws.applicationautoscaling.model.DescribeScalingActivitiesRequest
  ): ZIO[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    zio.aws.applicationautoscaling.model.DescribeScalingActivitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeScalingActivitiesPaginated(request))
  def putScalingPolicy(
      request: zio.aws.applicationautoscaling.model.PutScalingPolicyRequest
  ): ZIO[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    zio.aws.applicationautoscaling.model.PutScalingPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putScalingPolicy(request))
  def describeScalingPolicies(
      request: zio.aws.applicationautoscaling.model.DescribeScalingPoliciesRequest
  ): ZStream[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    zio.aws.applicationautoscaling.model.ScalingPolicy.ReadOnly
  ] = ZStream.serviceWithStream(_.describeScalingPolicies(request))
  def describeScalingPoliciesPaginated(
      request: zio.aws.applicationautoscaling.model.DescribeScalingPoliciesRequest
  ): ZIO[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    zio.aws.applicationautoscaling.model.DescribeScalingPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeScalingPoliciesPaginated(request))
  def registerScalableTarget(
      request: zio.aws.applicationautoscaling.model.RegisterScalableTargetRequest
  ): ZIO[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    zio.aws.applicationautoscaling.model.RegisterScalableTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerScalableTarget(request))
  def deregisterScalableTarget(
      request: zio.aws.applicationautoscaling.model.DeregisterScalableTargetRequest
  ): ZIO[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterScalableTarget(request))
  def describeScalableTargets(
      request: zio.aws.applicationautoscaling.model.DescribeScalableTargetsRequest
  ): ZStream[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    zio.aws.applicationautoscaling.model.ScalableTarget.ReadOnly
  ] = ZStream.serviceWithStream(_.describeScalableTargets(request))
  def describeScalableTargetsPaginated(
      request: zio.aws.applicationautoscaling.model.DescribeScalableTargetsRequest
  ): ZIO[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    zio.aws.applicationautoscaling.model.DescribeScalableTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeScalableTargetsPaginated(request))
  def describeScheduledActions(
      request: zio.aws.applicationautoscaling.model.DescribeScheduledActionsRequest
  ): ZStream[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly
  ] = ZStream.serviceWithStream(_.describeScheduledActions(request))
  def describeScheduledActionsPaginated(
      request: zio.aws.applicationautoscaling.model.DescribeScheduledActionsRequest
  ): ZIO[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeScheduledActionsPaginated(request))
  def deleteScheduledAction(
      request: zio.aws.applicationautoscaling.model.DeleteScheduledActionRequest
  ): ZIO[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    zio.aws.applicationautoscaling.model.DeleteScheduledActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteScheduledAction(request))
  def putScheduledAction(
      request: zio.aws.applicationautoscaling.model.PutScheduledActionRequest
  ): ZIO[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    zio.aws.applicationautoscaling.model.PutScheduledActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putScheduledAction(request))
  def deleteScalingPolicy(
      request: zio.aws.applicationautoscaling.model.DeleteScalingPolicyRequest
  ): ZIO[
    zio.aws.applicationautoscaling.ApplicationAutoScaling,
    AwsError,
    zio.aws.applicationautoscaling.model.DeleteScalingPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteScalingPolicy(request))
}
